/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.IAirflowTile;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.TilePotteryPot;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPotteryPot
extends DCTileBlock
implements IAirflowTile {
    public BlockPotteryPot(String s) {
        super(Material.field_151571_B, s, 0);
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (tile != null && tile instanceof TilePotteryPot) {
                if (player.func_70093_af() && DCUtil.isEmpty((ItemStack)held)) {
                    int type = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
                    boolean f = ((TilePotteryPot)tile).hasCap();
                    boolean next = !f;
                    DCLogger.debugLog((String)("pottery type " + f + "->" + next));
                    ((TilePotteryPot)tile).setCap(next);
                } else {
                    if (!DCUtil.isEmpty((ItemStack)held) && DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)held, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) {
                        return true;
                    }
                    player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePotteryPot();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == FoodInit.potteryPot) {
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)), 2);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != FoodInit.potteryPot) {
            return false;
        }
        int meta = state.func_177230_c().func_176201_c(state) & 3;
        return meta == 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public DCAirflow getAirflow(World world, BlockPos to, BlockPos from) {
        return DCAirflow.NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.BLUE.toString() + "COLD" + TextFormatting.GRAY.toString() + " ~ " + TextFormatting.RED.toString() + "KILN");
            tooltip.add(DCName.REQUIRE_CLIMATE.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.OUTPUT_ITEM.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
        tooltip.add(TextFormatting.BOLD.toString() + "Tier 1");
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }
}

