/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.TileSilkwormBox;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSilkwormBox
extends DCTileBlock {
    public BlockSilkwormBox(String s) {
        super(Material.field_151575_d, s, 3);
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.field_70170_p.field_72995_K && player != null && hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (tile instanceof TileSilkwormBox) {
                TileSilkwormBox box = (TileSilkwormBox)tile;
                if (!DCUtil.isEmpty((ItemStack)held) && held.func_77973_b() == Item.func_150898_a((Block)FoodInit.leavesMorus)) {
                    int ins = 0;
                    if (DCUtil.isEmpty((ItemStack)box.func_70301_a(0))) {
                        ins = held.func_190916_E();
                    } else {
                        ins = TileSilkwormBox.isItemStackable(held, box.func_70301_a(0));
                        player.func_184185_a(SoundEvents.field_187577_bU, 0.5f, 1.0f);
                    }
                    if (ins > 0) {
                        box.incrStackInSlot(0, held.func_77979_a(ins));
                        player.func_184185_a(SoundEvents.field_187577_bU, 0.5f, 1.0f);
                    }
                } else if (!DCUtil.isEmpty((ItemStack)held) && held.func_77973_b() == MainInit.silkworm) {
                    int c = 0;
                    for (int i = 1; i < 10; ++i) {
                        if (DCUtil.isEmpty((ItemStack)held) || !DCUtil.isEmpty((ItemStack)box.func_70301_a(i))) continue;
                        box.incrStackInSlot(i, held.func_77979_a(1));
                        ++c;
                    }
                    if (c > 0) {
                        player.func_184185_a(SoundEvents.field_187577_bU, 0.5f, 1.0f);
                    }
                } else {
                    player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSilkwormBox();
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == FoodInit.silkwormBox) {
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != FoodInit.silkwormBox) {
            return false;
        }
        int meta = state.func_177230_c().func_176201_c(state) & 3;
        return meta == 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }
}

