/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.IAirflowTile;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.TileSkillet;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSkillet
extends DCTileBlock
implements IAirflowTile {
    protected static final AxisAlignedBB AABB_PLATE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockSkillet(String s) {
        super(Material.field_151571_B, s, 0);
        this.func_149672_a(SoundType.field_185858_k);
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (tile != null && tile instanceof TileSkillet && !player.func_70093_af()) {
                if (!DCUtil.isEmpty((ItemStack)held) && DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)held, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) {
                    return true;
                }
                player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null && !placer.field_70170_p.field_72995_K && placer instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)placer;
        }
        state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)placer.func_174811_aO());
        return state;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSkillet();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_PLATE;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == FoodInit.skillet) {
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)), 2);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != FoodInit.skillet) {
            return false;
        }
        int meta = state.func_177230_c().func_176201_c(state) & 3;
        return meta == 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && BlockSkillet.isLit((IBlockAccess)world, pos)) {
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && rand.nextInt(c) == 0 && rand.nextFloat() < 0.25f) {
                double x = (double)pos.func_177958_n() + 0.5 + rand.nextDouble() * 0.25;
                double y = (double)pos.func_177956_o() + 0.75 + rand.nextDouble() * 0.25;
                double z = (double)pos.func_177952_p() + 0.5 + rand.nextDouble() * 0.25;
                double dx = rand.nextDouble() * 0.05;
                double dy = rand.nextDouble() * 0.05;
                double dz = rand.nextDouble() * 0.05;
                world.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, 0.0, dy, 0.0, new int[0]);
            }
        }
    }

    public DCAirflow getAirflow(World world, BlockPos to, BlockPos from) {
        return DCAirflow.NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "BOIL+");
            tooltip.add(DCName.REQUIRE_CLIMATE.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.OUTPUT_ITEM.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
        tooltip.add(TextFormatting.BOLD.toString() + "Tier 1");
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }
}

