/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import defeatedcrow.hac.food.gui.ContainerAgingBarrel;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.IAgingRecipeDC;
import defeatedcrow.hac.main.config.MainCoreConfig;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import defeatedcrow.hac.plugin.DrinkPotionType;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileAgingBarrel
extends ClimateReceiverLockable
implements ISidedInventory {
    public AgingTank inputT = new AgingTank(5000);
    public int lastDay = 0;
    public int startDay = 0;
    public int maxCount = -1;
    private int lastTier = 0;
    private int lastBurn = 0;
    private int lastInT = 0;
    private int lastOutT = 0;
    public IAgingRecipeDC currentRecipe = null;
    private int count = 10;
    public DCInventory inv = new DCInventory(this.func_70302_i_());
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidSlots();
            if (this.hasAgingFluid()) {
                if (DCTimeHelper.getDay((World)this.func_145831_w()) > this.lastDay) {
                    this.lastDay = DCTimeHelper.getDay((World)this.func_145831_w());
                    if (this.startDay == 0) {
                        this.startDay = this.lastDay;
                    } else {
                        int c = this.inputT.getAge();
                        int d = this.lastDay - this.startDay;
                        if (d > 0) {
                            this.inputT.setAge(d);
                        }
                    }
                }
            } else {
                this.inputT.setAge(0);
                boolean b = this.startDay > 0;
                this.maxCount = -1;
                this.startDay = 0;
                this.currentRecipe = null;
                if (b) {
                    this.func_70296_d();
                }
            }
            if (this.maxCount > 0) {
                if (this.inputT.getAge() >= this.maxCount && this.canRecipeProcess() && this.onProcess()) {
                    this.maxCount = -1;
                    this.func_70296_d();
                }
            } else {
                this.canStartProcess();
            }
        }
    }

    protected void onServerUpdate() {
        if (this.count > 0) {
            --this.count;
        } else {
            boolean flag = false;
            if (this.inputT.getFluidAmount() + this.inputT.getFluidIdName().hashCode() != this.lastInT) {
                flag = true;
                this.lastInT = this.inputT.getFluidAmount() + this.inputT.getFluidIdName().hashCode();
            }
            if (flag) {
                String f1 = this.inputT.getFluidType() == null ? "empty" : this.inputT.getFluidType().getName();
                int a1 = this.inputT.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, f1, a1));
            }
            this.count = 10;
        }
    }

    public boolean isActive() {
        return this.maxCount > 0;
    }

    public int getCurrentBurnTime() {
        return this.inputT.getAge();
    }

    public int getMaxBurnTime() {
        return this.maxCount;
    }

    public void processFluidSlots() {
        this.processTank(this.inputT, 0, 1, false);
    }

    protected void processTank(AgingTank tank, int slot1, int slot2, boolean flag) {
        if (!this.onDrainTank(tank, slot1, slot2, flag)) {
            this.onFillTank(tank, slot1, slot2);
        }
    }

    protected boolean onFillTank(AgingTank tank, int slot1, int slot2) {
        block9: {
            ItemStack ret;
            boolean loose;
            block10: {
                FluidStack fill;
                block11: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block9;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = Math.min(dummy.getTankProperties()[0].getCapacity(), tank.getCapacity());
                    FluidStack fc = dummy.drain(max, false);
                    if (fc == null || fc.amount <= 0 || !tank.canFillTarget(fc)) break block10;
                    ret = ItemStack.field_190927_a;
                    loose = false;
                    boolean b = false;
                    int rem = tank.getCapacity() - tank.getFluidAmount();
                    fc = dummy.drain(rem, false);
                    if (fc == null) break block10;
                    fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill == null) break block10;
                    if (DCUtil.isEmpty((ItemStack)ret) || DCUtil.isEmpty((ItemStack)out)) break block11;
                    if (TileAgingBarrel.isItemStackable(ret, out) <= 0) break block10;
                }
                loose = true;
                tank.fill(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(AgingTank tank, int slot1, int slot2, boolean flag) {
        block14: {
            int age;
            ItemStack ret;
            boolean loose;
            block15: {
                int fill;
                block16: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (tank.getFluidAmount() <= 0 || dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block14;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    FluidStack send = tank.getFluid();
                    age = tank.getAge() / MainCoreConfig.aging_day;
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    boolean b = false;
                    int rem = max;
                    if (fc == null || fc.amount == 0) {
                        b = true;
                    } else if (tank.getFluidType() == fc.getFluid()) {
                        rem = max - fc.amount;
                        if (tank.getFluidAmount() <= rem) {
                            b = true;
                        }
                    }
                    if (!b) break block15;
                    FluidStack drain = tank.drain(rem, false);
                    fill = 0;
                    fill = dummy.fill(drain, true);
                    ret = dummy.getContainer();
                    if (fill <= 0) break block15;
                    if (DCUtil.isEmpty((ItemStack)ret) || DCUtil.isEmpty((ItemStack)out)) break block16;
                    if (TileAgingBarrel.isItemStackable(ret, out) <= 0) break block15;
                }
                loose = true;
                tank.drain(fill, true);
            }
            if (loose) {
                if (age > 0 && !DCUtil.isEmpty((ItemStack)ret) && ret.hasCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null)) {
                    IDrinkCustomize drink = (IDrinkCustomize)ret.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
                    drink.setAging(age);
                }
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean hasAgingFluid() {
        Fluid f = this.inputT.getFluidType();
        if (f != null) {
            if (this.currentRecipe != null && this.currentRecipe.matches(this.inputT.getFluid())) {
                return true;
            }
            if (this.canStartProcess()) {
                return true;
            }
            DrinkPotionType.PotionSet eff = DrinkPotionType.getPotionSet(f);
            if (eff != null && !eff.potion.func_76398_f()) {
                return true;
            }
        }
        return false;
    }

    public boolean canRecipeProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        return this.currentRecipe != null && this.currentRecipe.matches(inf);
    }

    public boolean canStartProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        this.currentRecipe = MainAPIManager.brewingRegister.getAgingRecipe(this.current, inf);
        if (this.currentRecipe != null) {
            this.maxCount = this.currentRecipe.agingDay();
            return true;
        }
        return false;
    }

    public boolean onProcess() {
        if (this.currentRecipe != null) {
            FluidStack inF = this.currentRecipe.getInputFluid();
            FluidStack outF = this.currentRecipe.getOutputFluid();
            int c = this.inputT.getAge();
            int a = MathHelper.func_76141_d((float)((float)this.inputT.getFluidAmount() * 0.9f));
            if (outF != null) {
                this.inputT.setFluid(new FluidStack(outF.getFluid(), a));
                this.inputT.setAge(c);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isSuitableClimate() {
        if (this.current != null) {
            if (this.current.getHeat().getID() > DCHeatTier.HOT.getID() || this.current.getHeat().getID() < DCHeatTier.COLD.getID()) {
                return false;
            }
            if (this.current.getHumidity().getID() > DCHumidity.WET.getID()) {
                return false;
            }
            if (this.current.getAirflow().getID() > DCAirflow.NORMAL.getID()) {
                return false;
            }
        }
        return true;
    }

    public String climateSuitableMassage() {
        if (this.current == null) {
            return "dcs.gui.message.nullclimate";
        }
        if (this.isSuitableClimate()) {
            return "dcs.gui.message.suitableclimate";
        }
        return "dcs.gui.message.aging.badclimate";
    }

    protected int[] slotsTop() {
        return new int[]{0};
    }

    protected int[] slotsBottom() {
        return new int[]{1};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1};
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.inv.func_70298_a(i, num);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv.func_70299_a(i, stack);
    }

    public String func_70005_c_() {
        return "dcs.gui.device.barrel";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            if (DCUtil.isEmpty((ItemStack)stack)) {
                return false;
            }
            IFluidHandlerItem cont = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            } else if (stack.func_77973_b() instanceof IFluidHandlerItem) {
                cont = (IFluidHandlerItem)stack.func_77973_b();
            }
            return cont != null;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        return DCInventory.isItemStackable((ItemStack)target, (ItemStack)current);
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.inv.incrStackInSlot(i, input);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.inputT.getAge();
            }
            case 1: {
                return this.maxCount;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.inputT.setAge(value);
                break;
            }
            case 1: {
                this.maxCount = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputT);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.readFromNBT(tag);
        this.maxCount = tag.func_74762_e("MaxTime");
        this.startDay = tag.func_74762_e("StartDay");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("MaxTime", this.maxCount);
        tag.func_74768_a("StartDay", this.startDay);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("MaxTime", this.maxCount);
        tag.func_74768_a("StartDay", this.startDay);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inv.readFromNBT(tag);
        this.maxCount = tag.func_74762_e("MaxTime");
        this.startDay = tag.func_74762_e("StartDay");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerAgingBarrel(this, playerInventory);
    }

    public String func_174875_k() {
        return "dcs_climate:aging";
    }

    public class AgingTank
    extends DCTank {
        public AgingTank(int cap) {
            super(cap);
        }

        public AgingTank readFromNBT(NBTTagCompound nbt, String key) {
            NBTTagList list;
            NBTTagCompound nbt2;
            int c;
            AgingTank ret = this;
            if (nbt.func_74764_b("cap") && (c = nbt.func_74762_e("cap")) != this.capacity) {
                ret = new AgingTank(c);
            }
            if (!(nbt2 = (list = nbt.func_150295_c(key, 10)).func_150305_b(0)).func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt2);
                ret.setFluid(fluid);
            } else {
                ret.setFluid(null);
            }
            return ret;
        }

        public int getFluidAge(FluidStack target) {
            if (target == null) {
                return 0;
            }
            if (target.tag == null) {
                return 0;
            }
            if (target.tag.func_74764_b("age")) {
                return target.tag.func_74762_e("age");
            }
            return 0;
        }

        public int getAge() {
            if (this.fluid == null) {
                return 0;
            }
            if (this.fluid.tag == null) {
                return 0;
            }
            if (this.fluid.tag.func_74764_b("age")) {
                return this.fluid.tag.func_74762_e("age");
            }
            return 0;
        }

        public void setAge(int i) {
            if (this.fluid == null) {
                return;
            }
            if (this.fluid.tag == null) {
                this.fluid.tag = new NBTTagCompound();
            }
            this.fluid.tag.func_74768_a("age", i);
        }

        public boolean canFillTarget(FluidStack get) {
            if (get != null) {
                if (this.isEmpty()) {
                    return true;
                }
                if (get.getFluid() == this.getFluidType()) {
                    return this.getAge() < 2 || this.getAge() <= this.getFluidAge(get);
                }
            }
            return false;
        }

        public boolean canDrainTarget(FluidStack get) {
            if (get != null) {
                if (this.isEmpty()) {
                    return false;
                }
                if (get.getFluid() == this.getFluidType()) {
                    return true;
                }
            }
            return false;
        }
    }
}

