/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.block.TileFluidProcessorBase;
import defeatedcrow.hac.food.gui.ContainerBrewingTank;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.IBrewingRecipeDC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TileBrewingTankWood
extends TileFluidProcessorBase {
    public IBrewingRecipeDC currentBrewing = null;

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidSlots();
            if (this.maxBurnTime > 0) {
                if (this.currentBurnTime >= this.maxBurnTime) {
                    if (this.canRecipeProcess()) {
                        if (this.onProcess()) {
                            this.currentBurnTime = 0;
                            this.maxBurnTime = -1;
                            this.func_70296_d();
                        }
                    } else {
                        this.currentBurnTime = 0;
                        this.maxBurnTime = -1;
                        this.currentBrewing = null;
                        this.func_70296_d();
                    }
                } else if (this.canRecipeProcess()) {
                    ++this.currentBurnTime;
                } else {
                    this.currentBurnTime = 0;
                    this.maxBurnTime = -1;
                    this.currentBrewing = null;
                    this.func_70296_d();
                }
            } else if (this.canStartProcess()) {
                this.maxBurnTime = this.getProcessTime();
            }
        }
    }

    @Override
    public boolean canRecipeProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        if (this.currentBrewing == null) {
            return false;
        }
        if (this.currentBrewing.matchClimate(this.current) && this.currentBrewing.matches(ins, inf)) {
            int outAmo = this.currentBrewing.getOutputFluid() == null ? 0 : this.currentBrewing.getOutputFluid().amount;
            return this.currentBrewing.matchOutput(outs, outf) && this.outputT.getFluidAmount() + outAmo <= this.outputT.getCapacity();
        }
        return false;
    }

    @Override
    public boolean canStartProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        this.currentBrewing = MainAPIManager.brewingRegister.getBrewingRecipe(this.current, ins, inf);
        return this.currentBrewing != null && this.currentBrewing.matchOutput(outs, outf);
    }

    @Override
    public boolean onProcess() {
        if (this.currentBrewing != null) {
            int c1;
            ItemStack out = this.currentBrewing.getOutput();
            FluidStack inF = this.currentBrewing.getInputFluid();
            FluidStack outF = this.currentBrewing.getOutputFluid();
            if (outF != null && (c1 = this.outputT.fill(outF, false)) < outF.amount) {
                return false;
            }
            ArrayList<Object> required = new ArrayList<Object>(this.currentBrewing.getProcessedInput());
            if (!required.isEmpty()) {
                for (int i = this.getInputSlotTop(); i <= this.getInputSlotEnd(); ++i) {
                    ItemStack slot = this.func_70301_a(i);
                    if (DCUtil.isEmpty((ItemStack)slot)) continue;
                    boolean inRecipe = false;
                    Iterator req = required.iterator();
                    while (req.hasNext()) {
                        ArrayList list;
                        boolean match = false;
                        Object next = req.next();
                        int count = 1;
                        if (next instanceof ItemStack) {
                            count = ((ItemStack)next).func_190916_E();
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false) && slot.func_190916_E() >= count;
                        } else if (next instanceof List && (list = new ArrayList((List)next)) != null && !list.isEmpty()) {
                            for (ItemStack item : list) {
                                boolean f = OreDictionary.itemMatches((ItemStack)item, (ItemStack)slot, (boolean)false) && slot.func_190916_E() > 0;
                                if (!f) continue;
                                match = true;
                            }
                        }
                        if (!match) continue;
                        inRecipe = true;
                        required.remove(next);
                        this.func_70298_a(i, count);
                        break;
                    }
                    if (!inRecipe) break;
                }
                if (!required.isEmpty()) {
                    return false;
                }
            }
            if (inF != null) {
                this.inputT.drain(inF.amount, true);
            }
            if (outF != null) {
                this.outputT.fill(outF, true);
            }
            if (!DCUtil.isEmpty((ItemStack)out)) {
                this.insertResult(out.func_77946_l(), this.getOutputSlotTop(), this.getOutputSlotEnd() + 1);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public int getProcessTime() {
        return 200;
    }

    @Override
    public boolean isSuitableClimate() {
        if (this.current != null) {
            if (this.current.getHeat().getID() > DCHeatTier.HOT.getID() || this.current.getHeat().getID() < DCHeatTier.COLD.getID()) {
                return false;
            }
            if (this.current.getHumidity().getID() > DCHumidity.WET.getID() || this.current.getHumidity().getID() < DCHumidity.NORMAL.getID()) {
                return false;
            }
            if (this.current.getAirflow().getID() > DCAirflow.NORMAL.getID()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String climateSuitableMassage() {
        if (this.current == null) {
            return "dcs.gui.message.nullclimate";
        }
        if (this.isSuitableClimate()) {
            return "dcs.gui.message.suitableclimate";
        }
        return "dcs.gui.message.brewing.badclimate";
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBrewingTank(this, playerInventory);
    }

    @Override
    public String func_174875_k() {
        return "dcs_climate:brewing";
    }
}

