/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.recipe.IFluidRecipe;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageFluidProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public abstract class TileFluidProcessorBase
extends ClimateReceiverLockable
implements ISidedInventory {
    public DCTank inputT = new DCTank(5000);
    public DCTank outputT = new DCTank(5000);
    public int currentBurnTime = 0;
    public int maxBurnTime = -1;
    private int lastTier = 0;
    private int lastBurn = 0;
    private int lastInT = 0;
    private int lastOutT = 0;
    public IFluidRecipe currentRecipe = null;
    private int count = 10;
    public DCInventory inv = new DCInventory(this.func_70302_i_());
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidSlots();
            if (this.maxBurnTime > 0) {
                if (this.currentBurnTime >= this.maxBurnTime) {
                    if (this.canRecipeProcess()) {
                        if (this.onProcess()) {
                            this.currentBurnTime = 0;
                            this.maxBurnTime = -1;
                            this.func_70296_d();
                        }
                    } else {
                        this.currentBurnTime = 0;
                        this.maxBurnTime = -1;
                        this.currentRecipe = null;
                        this.func_70296_d();
                    }
                } else if (this.canRecipeProcess()) {
                    ++this.currentBurnTime;
                } else {
                    this.currentBurnTime = 0;
                    this.maxBurnTime = -1;
                    this.currentRecipe = null;
                    this.func_70296_d();
                }
            } else if (this.canStartProcess()) {
                this.maxBurnTime = this.getProcessTime();
            }
        }
    }

    protected void onServerUpdate() {
        if (this.count > 0) {
            --this.count;
        } else {
            boolean flag = false;
            if (this.inputT.getFluidAmount() + this.inputT.getFluidIdName().hashCode() != this.lastInT) {
                flag = true;
                this.lastInT = this.inputT.getFluidAmount() + this.inputT.getFluidIdName().hashCode();
            }
            if (this.outputT.getFluidAmount() + this.outputT.getFluidIdName().hashCode() != this.lastOutT) {
                flag = true;
                this.lastOutT = this.outputT.getFluidAmount() + this.outputT.getFluidIdName().hashCode();
            }
            if (flag) {
                String f1 = this.inputT.getFluidType() == null ? "empty" : this.inputT.getFluidType().getName();
                String f2 = this.outputT.getFluidType() == null ? "empty" : this.outputT.getFluidType().getName();
                int a1 = this.inputT.getFluidAmount();
                int a2 = this.outputT.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageFluidProcessor(this.field_174879_c, f1, a1, f2, a2));
            }
            this.count = 10;
        }
    }

    public boolean isActive() {
        return this.currentBurnTime > 0;
    }

    public int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void setCurrentBurnTime(int i) {
        this.currentBurnTime = i;
    }

    public void setMaxBurnTime(int i) {
        this.maxBurnTime = i;
    }

    public void processFluidSlots() {
        this.processTank(this.inputT, 0, 1, false);
        this.processTank(this.outputT, 2, 3, true);
    }

    protected void processTank(DCTank tank, int slot1, int slot2, boolean flag) {
        if (!this.onDrainTank(tank, slot1, slot2, flag)) {
            this.onFillTank(tank, slot1, slot2);
        }
    }

    protected boolean onFillTank(DCTank tank, int slot1, int slot2) {
        block9: {
            ItemStack ret;
            boolean loose;
            block10: {
                FluidStack fill;
                block11: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block9;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = Math.min(dummy.getTankProperties()[0].getCapacity(), tank.getCapacity());
                    FluidStack fc = dummy.drain(max, false);
                    if (fc == null || fc.amount <= 0 || !tank.canFillTarget(fc)) break block10;
                    ret = ItemStack.field_190927_a;
                    loose = false;
                    boolean b = false;
                    int rem = tank.getCapacity() - tank.getFluidAmount();
                    fc = dummy.drain(rem, false);
                    if (fc == null) break block10;
                    fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill == null) break block10;
                    if (DCUtil.isEmpty((ItemStack)ret) || DCUtil.isEmpty((ItemStack)out)) break block11;
                    if (TileFluidProcessorBase.isItemStackable(ret, out) <= 0) break block10;
                }
                loose = true;
                tank.fill(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(DCTank tank, int slot1, int slot2, boolean flag) {
        block13: {
            ItemStack ret;
            boolean loose;
            block14: {
                int fill;
                block15: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (tank.getFluidAmount() <= 0 || dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block13;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    FluidStack send = tank.getFluid();
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    boolean b = false;
                    int rem = max;
                    if (fc == null || fc.amount == 0) {
                        b = true;
                    } else if (tank.getFluidType() == fc.getFluid()) {
                        rem = max - fc.amount;
                        if (tank.getFluidAmount() <= rem) {
                            b = true;
                        }
                    }
                    if (!b) break block14;
                    FluidStack drain = tank.drain(rem, false);
                    fill = 0;
                    fill = dummy.fill(drain, true);
                    ret = dummy.getContainer();
                    if (fill <= 0) break block14;
                    if (DCUtil.isEmpty((ItemStack)ret) || DCUtil.isEmpty((ItemStack)out)) break block15;
                    if (TileFluidProcessorBase.isItemStackable(ret, out) <= 0) break block14;
                }
                loose = true;
                tank.drain(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public abstract int getProcessTime();

    public boolean canRecipeProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.currentRecipe.matchClimate(this.current) && this.currentRecipe.matches(ins, inf)) {
            int outAmo = this.currentRecipe.getOutputFluid() == null ? 0 : this.currentRecipe.getOutputFluid().amount;
            return this.currentRecipe.matchOutput(outs, outf, 3) && this.outputT.getFluidAmount() + outAmo <= this.outputT.getCapacity();
        }
        return false;
    }

    public boolean canStartProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        this.currentRecipe = RecipeAPI.registerFluidRecipes.getRecipe(this.current, ins, inf);
        return this.currentRecipe != null && this.currentRecipe.matchOutput(outs, outf, 3);
    }

    public boolean onProcess() {
        if (this.currentRecipe != null) {
            int c1;
            ItemStack out = this.currentRecipe.getOutput();
            ItemStack sec = this.currentRecipe.getSecondary();
            float chance = MathHelper.func_76123_f((float)(this.currentRecipe.getSecondaryChance() * 100.0f));
            FluidStack inF = this.currentRecipe.getInputFluid();
            FluidStack outF = this.currentRecipe.getOutputFluid();
            if (outF != null && (c1 = this.outputT.fill(outF, false)) < outF.amount) {
                return false;
            }
            ArrayList required = new ArrayList(this.currentRecipe.getProcessedInput());
            if (!required.isEmpty()) {
                for (int i = this.getInputSlotTop(); i <= this.getInputSlotEnd(); ++i) {
                    ItemStack slot = this.func_70301_a(i);
                    if (DCUtil.isEmpty((ItemStack)slot)) continue;
                    boolean inRecipe = false;
                    Iterator req = required.iterator();
                    while (req.hasNext()) {
                        ArrayList list;
                        boolean match = false;
                        Object next = req.next();
                        int count = 1;
                        if (next instanceof ItemStack) {
                            count = ((ItemStack)next).func_190916_E();
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false) && slot.func_190916_E() >= count;
                        } else if (next instanceof List && (list = new ArrayList((List)next)) != null && !list.isEmpty()) {
                            for (ItemStack item : list) {
                                boolean f = OreDictionary.itemMatches((ItemStack)item, (ItemStack)slot, (boolean)false) && slot.func_190916_E() > 0;
                                if (!f) continue;
                                match = true;
                            }
                        }
                        if (!match) continue;
                        inRecipe = true;
                        required.remove(next);
                        this.func_70298_a(i, count);
                        break;
                    }
                    if (!inRecipe) break;
                }
                if (!required.isEmpty()) {
                    return false;
                }
            }
            if (inF != null) {
                this.inputT.drain(inF.amount, true);
            }
            if (outF != null) {
                this.outputT.fill(outF, true);
            }
            if (!DCUtil.isEmpty((ItemStack)out)) {
                this.insertResult(out.func_77946_l(), this.getOutputSlotTop(), this.getOutputSlotEnd() + 1);
            }
            if (!DCUtil.isEmpty((ItemStack)sec) && (float)this.field_145850_b.field_73012_v.nextInt(100) < chance) {
                this.insertResult(sec.func_77946_l(), this.getOutputSlotTop(), this.getOutputSlotEnd() + 1);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public abstract boolean isSuitableClimate();

    public abstract String climateSuitableMassage();

    public int canInsertResult(ItemStack item, int s1, int s2) {
        return this.inv.canInsertResult(item, s1, s2);
    }

    public int insertResult(ItemStack item, int s1, int s2) {
        return this.inv.insertResult(item, s1, s2);
    }

    protected int getInputSlotTop() {
        return 4;
    }

    protected int getInputSlotEnd() {
        return 6;
    }

    protected int getOutputSlotTop() {
        return 7;
    }

    protected int getOutputSlotEnd() {
        return 9;
    }

    protected int[] slotsTop() {
        return new int[]{0, 2, 4, 5, 6};
    }

    protected int[] slotsBottom() {
        return new int[]{1, 3, 7, 8, 9};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public List<ItemStack> getInputs() {
        return this.inv.getInputs(4, 6);
    }

    public List<ItemStack> getOutputs() {
        return this.inv.getOutputs(7, 9);
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.inv.func_70298_a(i, num);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv.func_70299_a(i, stack);
    }

    public String func_70005_c_() {
        return "dcs.gui.device.fluidprocessor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 || i == 2) {
            if (DCUtil.isEmpty((ItemStack)stack)) {
                return false;
            }
            IFluidHandlerItem cont = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            } else if (stack.func_77973_b() instanceof IFluidHandlerItem) {
                cont = (IFluidHandlerItem)stack.func_77973_b();
            }
            return cont != null;
        }
        return i >= this.getInputSlotTop() && i <= this.getInputSlotEnd();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0 && index != 2 && (index < this.getInputSlotTop() || index > this.getInputSlotEnd());
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        return DCInventory.isItemStackable((ItemStack)target, (ItemStack)current);
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.inv.incrStackInSlot(i, input);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP) {
                return (T)this.inputT;
            }
            return (T)this.outputT;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.readFromNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.inputT = this.inputT.readFromNBT(tag, "Tank1");
        this.outputT = this.outputT.readFromNBT(tag, "Tank2");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank1");
        this.outputT.writeToNBT(tag, "Tank2");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank1");
        this.outputT.writeToNBT(tag, "Tank2");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inv.readFromNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.inputT = this.inputT.readFromNBT(tag, "Tank1");
        this.outputT = this.outputT.readFromNBT(tag, "Tank2");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public abstract Container func_174876_a(InventoryPlayer var1, EntityPlayer var2);

    public abstract String func_174875_k();
}

