/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.gui.ContainerIncubator;
import defeatedcrow.hac.food.item.brewing.ItemMedium;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.IMediumItem;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageIncubatorButton;
import defeatedcrow.hac.main.util.MainUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileIncubator
extends ClimateReceiverLockable
implements ISidedInventory {
    public int lastD = 0;
    public int lastClimate = 0;
    public boolean isOpen = false;
    public int numPlayersUsing = 0;
    protected DCInventory invs = new DCInventory(18);
    IItemHandler handlerSide = new SidedInvWrapper(this, EnumFacing.WEST){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public void updateTile() {
        if (!this.func_145831_w().field_72995_K && this.current != null) {
            int day = DCTimeHelper.getDay((World)this.func_145831_w());
            if (day > this.lastD) {
                for (int s = 0; s < 18; ++s) {
                    ItemStack item = this.func_70301_a(s);
                    if (DCUtil.isEmpty((ItemStack)item) || !this.func_94041_b(s, item)) continue;
                    if (item.func_77973_b() instanceof ItemMedium) {
                        int count;
                        IMicrobe microbe = ItemMedium.getMicrobeData(item);
                        int n = count = ((ItemMedium)item.func_77973_b()).getMedium(item) == EnumMedium.SIMPLE ? 3 : 5;
                        if (microbe == null) continue;
                        if (this.isSuitableClimate(microbe)) {
                            TileIncubator.addIncubationDays(item);
                            TileIncubator.removeUnsuitableDays(item);
                            int di = TileIncubator.getIncubationDays(item);
                            if (di < microbe.getIncubationDays()) continue;
                            ItemStack ret = ItemMedium.getMicrobeItem(item);
                            ret.func_190920_e(count);
                            this.func_70299_a(s, ret);
                            continue;
                        }
                        TileIncubator.addUnsuitableDays(item);
                        int bi = TileIncubator.getUnsuitableDays(item);
                        if (bi < microbe.getIncubationDays()) continue;
                        this.func_70298_a(s, 1);
                        continue;
                    }
                    if (!MainUtil.hasDic(item, "egg")) continue;
                    if (this.isSuitableClimateForChick()) {
                        TileIncubator.addIncubationDays(item);
                        int di = TileIncubator.getIncubationDays(item);
                        if (di < 3) continue;
                        ItemStack ret = new ItemStack(FoodInit.chickInEgg);
                        this.func_70299_a(s, ret);
                        continue;
                    }
                    if (this.getClimate().getHeat().getID() > DCHeatTier.BOIL.getID()) {
                        ItemStack ret = new ItemStack(MainInit.bakedApple, 1, 1);
                        this.func_70299_a(s, ret);
                        continue;
                    }
                    TileIncubator.addUnsuitableDays(item);
                    int bi = TileIncubator.getUnsuitableDays(item);
                    if (bi < 3) continue;
                    this.func_70298_a(s, 1);
                }
            }
            this.lastD = day;
        }
        if (this.current == null) {
            this.current = ClimateAPI.register.getClimateFromParam(DCHeatTier.WARM, DCHumidity.NORMAL, DCAirflow.NORMAL);
        }
    }

    public boolean isSuitableClimate(IMicrobe microbe) {
        DCHeatTier heat = this.current.getHeat();
        DCHumidity hum = this.current.getHumidity();
        DCAirflow air = this.current.getAirflow();
        return microbe.getHeats().contains(heat) && microbe.getHums().contains(hum) && microbe.getAirs().contains(air);
    }

    public boolean isSuitableClimateForChick() {
        DCHeatTier heat = this.current.getHeat();
        DCHumidity hum = this.current.getHumidity();
        DCAirflow air = this.current.getAirflow();
        return heat == DCHeatTier.WARM && hum == DCHumidity.NORMAL && air.getID() > DCAirflow.TIGHT.getID();
    }

    public static ItemStack addIncubationDays(ItemStack item) {
        if (!DCUtil.isEmpty((ItemStack)item)) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            int i = tag.func_74762_e("microbe_days");
            tag.func_74768_a("microbe_days", ++i);
            item.func_77982_d(tag);
        }
        return item;
    }

    public static int getIncubationDays(ItemStack item) {
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("microbe_days")) {
            int i = tag.func_74762_e("microbe_days");
            return i;
        }
        return 0;
    }

    public static int getUnsuitableDays(ItemStack item) {
        if (!DCUtil.isEmpty((ItemStack)item)) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            int i = tag.func_74762_e("microbe_baddays");
            return i;
        }
        return 0;
    }

    public static ItemStack addUnsuitableDays(ItemStack item) {
        if (!DCUtil.isEmpty((ItemStack)item)) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            int i = tag.func_74762_e("microbe_baddays");
            tag.func_74768_a("microbe_baddays", ++i);
            item.func_77982_d(tag);
        }
        return item;
    }

    public static ItemStack removeUnsuitableDays(ItemStack item) {
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && (tag = item.func_77978_p()) != null && tag.func_74764_b("microbe_baddays")) {
            tag.func_82580_o("microbe_baddays");
            item.func_77982_d(tag);
        }
        return item;
    }

    public void setClimate(IClimate climate) {
        this.current = climate;
    }

    public void setClimateAndPacket(IClimate climate) {
        this.setClimate(climate);
        DCMainPacket.INSTANCE.sendToServer((IMessage)new MessageIncubatorButton(this.func_174877_v(), (short)climate.getClimateInt()));
    }

    protected int[] slots() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public int func_70302_i_() {
        return 18;
    }

    public ItemStack func_70301_a(int i) {
        return this.invs.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.invs.func_70298_a(i, num);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.invs.func_70299_a(i, stack);
    }

    public String func_70005_c_() {
        return "dcs.gui.device.incubator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            if (MainUtil.hasDic(stack, "egg")) {
                return true;
            }
            if (stack.func_77973_b() instanceof IMediumItem) {
                return true;
            }
        }
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slots();
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing direction) {
        return this.func_94041_b(index, itemStack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return !DCUtil.isEmpty((ItemStack)stack) && this.func_94041_b(index, stack);
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        return DCInventory.isItemStackable((ItemStack)target, (ItemStack)current);
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.invs.incrStackInSlot(i, input);
    }

    public ItemStack func_70304_b(int i) {
        return this.invs.func_70304_b(i);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.invs.func_174888_l();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean func_191420_l() {
        return this.invs.func_191420_l();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIncubator(this, playerInventory);
    }

    public String func_174875_k() {
        return this.func_70005_c_();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("LastDay", this.lastD);
        this.invs.writeToNBT(tag);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.invs.readFromNBT(tag);
        this.lastD = tag.func_74762_e("LastDay");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

