/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.BlockSilkwormBox;
import defeatedcrow.hac.food.gui.ContainerSilkwormBox;
import defeatedcrow.hac.main.MainInit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileSilkwormBox
extends ClimateReceiverLockable
implements ISidedInventory {
    public int currentH = 0;
    public int lastH = 0;
    public int count = 0;
    protected DCInventory invs = new DCInventory(19);
    IItemHandler handlerTop = new SidedInvWrapper(this, EnumFacing.UP){

        public int getSlotLimit(int slot) {
            return slot == 0 ? 64 : 1;
        }
    };
    IItemHandler handlerBottom = new SidedInvWrapper(this, EnumFacing.DOWN){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    IItemHandler handlerSide = new SidedInvWrapper(this, EnumFacing.WEST){

        public int getSlotLimit(int slot) {
            return slot == 0 ? 64 : 1;
        }
    };

    public void updateTile() {
        if (!this.func_145831_w().field_72995_K && this.current != null) {
            if (this.count > 20) {
                for (int s = 1; s < 10; ++s) {
                    ItemStack item = this.func_70301_a(s);
                    if (DCUtil.isEmpty((ItemStack)item) || item.func_77973_b() != MainInit.silkworm) continue;
                    if (item.func_77952_i() == 0) {
                        this.func_70299_a(s, new ItemStack(MainInit.silkworm, 1, 1));
                        continue;
                    }
                    if (item.func_77952_i() != 1 || !this.isActive()) continue;
                    NBTTagCompound tag = item.func_77978_p();
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    int stage = 0;
                    if (tag.func_74764_b("RearingStage")) {
                        stage = tag.func_74762_e("RearingStage");
                    }
                    if (++stage >= 50) {
                        boolean flag = false;
                        for (int s2 = 10; s2 < 19; ++s2) {
                            if (!DCUtil.isEmpty((ItemStack)this.func_70301_a(s2))) continue;
                            this.func_70299_a(s2, new ItemStack(MainInit.silkworm, 1, 2));
                            flag = true;
                            break;
                        }
                        if (!flag) continue;
                        this.func_70304_b(s);
                        this.func_70296_d();
                        continue;
                    }
                    if (stage % 10 == 0 || stage % 10 == 5) {
                        this.func_70298_a(0, 1);
                    }
                    tag.func_74768_a("RearingStage", stage);
                    item.func_77982_d(tag);
                }
                this.count = 0;
            } else {
                ++this.count;
            }
        }
        super.updateTile();
    }

    protected void onServerUpdate() {
        boolean leaves;
        super.onServerUpdate();
        boolean bl = leaves = !DCUtil.isEmpty((ItemStack)this.func_70301_a(0));
        if (BlockSilkwormBox.isLit((IBlockAccess)this.func_145831_w(), this.func_174877_v()) != leaves) {
            BlockSilkwormBox.changeLitState(this.func_145831_w(), this.func_174877_v(), leaves);
        }
    }

    public boolean isActive() {
        if (this.current != null) {
            boolean air = this.current.getAirflow() != DCAirflow.TIGHT;
            boolean temp = this.current.getHeat().getTier() > DCHeatTier.COOL.getTier() && this.current.getHeat().getTier() < DCHeatTier.BOIL.getTier();
            boolean leaves = !DCUtil.isEmpty((ItemStack)this.func_70301_a(0));
            return air && temp && leaves;
        }
        return false;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    protected int[] slotsBottom() {
        return new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    }

    public int func_70302_i_() {
        return 19;
    }

    public ItemStack func_70301_a(int i) {
        return this.invs.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.invs.func_70298_a(i, num);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.invs.func_70299_a(i, stack);
    }

    public String func_70005_c_() {
        return "dcs.gui.device.silkworm_box";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            if (i == 0) {
                return stack.func_77973_b() == Item.func_150898_a((Block)FoodInit.leavesMorus);
            }
            if (i > 9) {
                return false;
            }
            return stack.func_77973_b() == MainInit.silkworm && stack.func_77952_i() < 2;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing direction) {
        return this.func_94041_b(index, itemStack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 10;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        return DCInventory.isItemStackable((ItemStack)target, (ItemStack)current);
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.invs.incrStackInSlot(i, input);
    }

    public ItemStack func_70304_b(int i) {
        return this.invs.func_70304_b(i);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentH;
            }
            case 1: {
                return this.lastH;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentH = value;
                break;
            }
            case 1: {
                this.lastH = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.invs.func_174888_l();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean func_191420_l() {
        return this.invs.func_191420_l();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSilkwormBox(this, playerInventory);
    }

    public String func_174875_k() {
        return this.func_70005_c_();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("CurrentDay", this.currentH);
        tag.func_74768_a("LastDay", this.lastH);
        this.invs.writeToNBT(tag);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.invs.readFromNBT(tag);
        this.currentH = tag.func_74762_e("CurrentDay");
        this.lastH = tag.func_74762_e("LastDay");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

