/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.block.TileFluidProcessorBase;
import defeatedcrow.hac.food.gui.ContainerStillPot;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.IStillRecipeDC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileStillPot
extends TileFluidProcessorBase {
    public IStillRecipeDC currentStill = null;
    public int speed = 0;

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.speed = this.highTemp.getTier() - this.lowTemp.getTier();
            this.processFluidSlots();
            this.extractOutputFluid();
            if (this.maxBurnTime > 0) {
                if (this.currentBurnTime >= this.maxBurnTime) {
                    if (this.canRecipeProcess()) {
                        if (this.onProcess()) {
                            this.currentBurnTime = 0;
                            this.maxBurnTime = -1;
                            this.func_70296_d();
                        }
                    } else {
                        this.currentBurnTime = 0;
                        this.maxBurnTime = -1;
                        this.currentStill = null;
                        this.func_70296_d();
                    }
                } else if (this.canRecipeProcess()) {
                    this.currentBurnTime += this.speed;
                } else {
                    this.currentBurnTime = 0;
                    this.maxBurnTime = -1;
                    this.currentStill = null;
                    this.func_70296_d();
                }
            } else if (this.canStartProcess()) {
                this.maxBurnTime = this.getProcessTime();
            }
        }
    }

    public boolean extractOutputFluid() {
        IFluidHandler tank;
        TileEntity tile;
        int cap = this.outputT.getCapacity();
        int amo = this.outputT.getFluidAmount();
        int mov = 200;
        if (this.outputT.isEmpty() || amo <= 0) {
            return false;
        }
        EnumFacing face = EnumFacing.NORTH;
        EnumFacing side = DCState.getFace((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c), (PropertyDirection)DCState.FACING);
        if (side != null && face.func_176740_k().func_176722_c()) {
            face = side.func_176746_e();
        }
        if ((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face))) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) != null && tank.getTankProperties() != null && tank.getTankProperties().length > 0) {
            int i = Math.min(mov, amo);
            FluidStack ret = new FluidStack(this.outputT.getFluidType(), i);
            int fill = tank.fill(ret, false);
            if (fill > 0) {
                ret = this.outputT.drain(fill, true);
                tank.fill(ret, true);
                tile.func_70296_d();
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRecipeProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        if (this.currentStill == null) {
            return false;
        }
        if (this.currentStill.matchClimate(this.highTemp, this.lowTemp) && this.currentStill.matches(ins, inf)) {
            int outAmo = this.currentStill.getOutputFluid() == null ? 0 : this.currentStill.getOutputFluid().amount;
            return this.currentStill.matchOutput(outs, outf) && this.outputT.getFluidAmount() + outAmo <= this.outputT.getCapacity();
        }
        return false;
    }

    @Override
    public boolean canStartProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        this.currentStill = MainAPIManager.brewingRegister.getStillRecipe(this.highTemp, this.lowTemp, ins, inf);
        return this.currentStill != null && this.currentStill.matchOutput(outs, outf);
    }

    @Override
    public boolean onProcess() {
        if (this.currentStill != null) {
            int c1;
            ItemStack out = this.currentStill.getOutput();
            FluidStack inF = this.currentStill.getInputFluid();
            FluidStack outF = this.currentStill.getOutputFluid();
            if (outF != null && (c1 = this.outputT.fill(outF, false)) < outF.amount) {
                return false;
            }
            ArrayList<Object> required = new ArrayList<Object>(this.currentStill.getProcessedInput());
            if (!required.isEmpty()) {
                for (int i = this.getInputSlotTop(); i <= this.getInputSlotEnd(); ++i) {
                    ItemStack slot = this.func_70301_a(i);
                    if (DCUtil.isEmpty((ItemStack)slot)) continue;
                    boolean inRecipe = false;
                    Iterator req = required.iterator();
                    while (req.hasNext()) {
                        ArrayList list;
                        boolean match = false;
                        Object next = req.next();
                        int count = 1;
                        if (next instanceof ItemStack) {
                            count = ((ItemStack)next).func_190916_E();
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false) && slot.func_190916_E() >= count;
                        } else if (next instanceof List && (list = new ArrayList((List)next)) != null && !list.isEmpty()) {
                            for (ItemStack item : list) {
                                boolean f = OreDictionary.itemMatches((ItemStack)item, (ItemStack)slot, (boolean)false) && slot.func_190916_E() > 0;
                                if (!f) continue;
                                match = true;
                            }
                        }
                        if (!match) continue;
                        inRecipe = true;
                        required.remove(next);
                        this.func_70298_a(i, count);
                        break;
                    }
                    if (!inRecipe) break;
                }
                if (!required.isEmpty()) {
                    return false;
                }
            }
            if (inF != null) {
                this.inputT.drain(inF.amount, true);
            }
            if (outF != null) {
                this.outputT.fill(outF, true);
            }
            if (!DCUtil.isEmpty((ItemStack)out)) {
                this.insertResult(out.func_77946_l(), this.getOutputSlotTop(), this.getOutputSlotEnd() + 1);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public int getProcessTime() {
        return 100;
    }

    @Override
    public boolean isSuitableClimate() {
        return this.current == null || this.highTemp.getID() >= DCHeatTier.HOT.getID() && this.lowTemp.getID() <= DCHeatTier.NORMAL.getID();
    }

    @Override
    public String climateSuitableMassage() {
        if (this.current == null) {
            return "dcs.gui.message.nullclimate";
        }
        if (this.isSuitableClimate()) {
            return "dcs.gui.message.suitableclimate";
        }
        return "dcs.gui.message.still.badclimate";
    }

    @Override
    protected int getInputSlotTop() {
        return 4;
    }

    @Override
    protected int getInputSlotEnd() {
        return 5;
    }

    @Override
    protected int getOutputSlotTop() {
        return 6;
    }

    @Override
    protected int getOutputSlotEnd() {
        return 6;
    }

    @Override
    protected int[] slotsTop() {
        return new int[]{0, 2, 4, 5};
    }

    @Override
    protected int[] slotsBottom() {
        return new int[]{1, 3, 6};
    }

    @Override
    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inv.getInputs(4, 5);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.inv.getOutputs(6, 6);
    }

    @Override
    public int func_70302_i_() {
        return 7;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerStillPot(this, playerInventory);
    }

    @Override
    public String func_174875_k() {
        return "dcs_climate:still";
    }

    @Override
    public String func_70005_c_() {
        return "dcs.gui.device.still";
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
            case 3: {
                return this.highTemp == null ? 0 : this.highTemp.getID();
            }
            case 4: {
                return this.lowTemp == null ? 0 : this.lowTemp.getID();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
                break;
            }
            case 3: {
                this.highTemp = DCHeatTier.getTypeByID((int)value);
                break;
            }
            case 4: {
                this.lowTemp = DCHeatTier.getTypeByID((int)value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 5;
    }
}

