/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.block.TileFluidProcessorBase;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.DrinkCustomizer;
import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import defeatedcrow.hac.food.gui.ContainerFluidProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.OreDictionary;

public class TileTeaPot
extends TileFluidProcessorBase {
    public DrinkCustomizer cap = new DrinkCustomizer();
    protected int milkCount = 0;
    protected int sugarCount = 0;

    @Override
    public int getProcessTime() {
        if (this.current != null) {
            if (this.current.getHeat() == DCHeatTier.BOIL) {
                return 8;
            }
            if (this.current.getHeat().getTier() > DCHeatTier.BOIL.getTier()) {
                return 4;
            }
        }
        return 20;
    }

    public int getMilkCount() {
        return this.milkCount;
    }

    public int getSugarCount() {
        return this.sugarCount;
    }

    public void setMilkCount(int i) {
        this.milkCount = i;
    }

    public void setSugarCount(int i) {
        this.sugarCount = i;
    }

    public boolean setMilk(DrinkMilk milk) {
        if (milk.id == 0) {
            if (this.cap.getMilk().id == 0) {
                return false;
            }
            this.cap.setMilk(DrinkMilk.NONE);
            this.milkCount = 0;
            return true;
        }
        if (this.cap.getMilk().id == 0) {
            this.cap.setMilk(milk);
            this.milkCount = 4;
            return true;
        }
        if (this.cap.milkID == milk.id && this.milkCount < 64) {
            this.milkCount += 4;
            if (this.milkCount > 64) {
                this.milkCount = 64;
            }
            return true;
        }
        return false;
    }

    public boolean setSugar(DrinkSugar sugar) {
        if (sugar.id == 0) {
            if (this.cap.sugarID == 0) {
                return false;
            }
            this.cap.setSugar(DrinkSugar.NONE);
            this.sugarCount = 0;
            return true;
        }
        if (this.cap.sugarID == 0) {
            this.cap.setSugar(sugar);
            this.sugarCount = 4;
            return true;
        }
        if (this.cap.sugarID == sugar.id && this.sugarCount < 64) {
            this.sugarCount += 4;
            if (this.sugarCount > 64) {
                this.sugarCount = 64;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onDrainTank(DCTank tank, int slot1, int slot2, boolean flag) {
        ItemStack in = this.func_70301_a(slot1);
        ItemStack out = this.func_70301_a(slot2);
        if (DCUtil.isEmpty((ItemStack)in)) {
            return false;
        }
        IFluidHandlerItem dummy = null;
        ItemStack in2 = in.func_77946_l();
        if (in2.func_190916_E() > 1) {
            in2.func_190920_e(1);
        }
        if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
            dummy = (IFluidHandlerItem)in2.func_77973_b();
        }
        if (tank.getFluidAmount() > 0 && dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0) {
            boolean loose = false;
            ItemStack ret = ItemStack.field_190927_a;
            int max = dummy.getTankProperties()[0].getCapacity();
            FluidStack fc = dummy.drain(max, false);
            boolean b = false;
            int rem = max;
            if (fc == null || fc.amount == 0) {
                b = true;
            } else {
                rem = max - fc.amount;
                if (tank.getFluidAmount() <= rem) {
                    b = true;
                }
            }
            if (b) {
                FluidStack drain = tank.drain(rem, false);
                int fill = 0;
                fill = dummy.fill(drain, true);
                ret = dummy.getContainer();
                if (!DCUtil.isEmpty((ItemStack)ret) && ret.hasCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null)) {
                    IDrinkCustomize drink = (IDrinkCustomize)ret.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
                    DrinkMilk milk = this.cap.getMilk();
                    DrinkSugar sugar = this.cap.getSugar();
                    if (drink.setMilk(milk)) {
                        --this.milkCount;
                        if (this.milkCount <= 0) {
                            this.cap.setMilk(DrinkMilk.NONE);
                            this.milkCount = 0;
                        }
                    }
                    if (drink.setSugar(sugar)) {
                        --this.sugarCount;
                        if (this.sugarCount <= 0) {
                            this.cap.setSugar(DrinkSugar.NONE);
                            this.sugarCount = 0;
                        }
                    }
                }
                if (fill > 0 && this.canInsertResult(ret, slot2, slot2 + 1) != 0) {
                    loose = true;
                    tank.drain(fill, true);
                }
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRecipeProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.currentRecipe.matchClimate(this.current) && this.currentRecipe.matches(ins, inf)) {
            int outAmo = this.currentRecipe.getOutputFluid() == null ? 0 : this.currentRecipe.getOutputFluid().amount;
            return this.currentRecipe.matchOutput(outs, outf, 0) && this.outputT.getFluidAmount() + outAmo <= this.outputT.getCapacity();
        }
        return false;
    }

    @Override
    public boolean canStartProcess() {
        if (!this.isSuitableClimate()) {
            return false;
        }
        FluidStack inf = this.inputT.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf = this.outputT.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        this.currentRecipe = RecipeAPI.registerFluidRecipes.getRecipe(this.current, ins, inf);
        return this.currentRecipe != null && this.currentRecipe.matchOutput(outs, outf, 0);
    }

    @Override
    public boolean onProcess() {
        if (this.currentRecipe != null) {
            ItemStack out = this.currentRecipe.getOutput();
            ItemStack sec = this.currentRecipe.getSecondary();
            float chance = MathHelper.func_76123_f((float)(this.currentRecipe.getSecondaryChance() * 100.0f));
            FluidStack inF = this.currentRecipe.getInputFluid();
            FluidStack outF = this.currentRecipe.getOutputFluid();
            if (inF != null) {
                this.inputT.drain(inF.amount, true);
            }
            ArrayList required = new ArrayList(this.currentRecipe.getProcessedInput());
            for (int i = 4; i < 7; ++i) {
                ItemStack slot = this.func_70301_a(i);
                if (DCUtil.isEmpty((ItemStack)slot)) continue;
                boolean inRecipe = false;
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    ArrayList list;
                    boolean match = false;
                    Object next = req.next();
                    int count = 1;
                    if (next instanceof ItemStack) {
                        count = ((ItemStack)next).func_190916_E();
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false) && slot.func_190916_E() >= count;
                    } else if (next instanceof ArrayList && (list = new ArrayList((ArrayList)next)) != null && !list.isEmpty()) {
                        for (ItemStack item : list) {
                            boolean f = OreDictionary.itemMatches((ItemStack)item, (ItemStack)slot, (boolean)false) && slot.func_190916_E() > 0;
                            if (!f) continue;
                            match = true;
                        }
                    }
                    if (!match) continue;
                    inRecipe = true;
                    required.remove(next);
                    this.func_70298_a(i, count);
                    break;
                }
                if (!inRecipe) break;
            }
            if (outF != null) {
                this.outputT.fill(outF, true);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuitableClimate() {
        return this.current != null;
    }

    @Override
    public String climateSuitableMassage() {
        if (this.current == null) {
            return "dcs.gui.message.nullclimate";
        }
        return "dcs.gui.message.suitableclimate";
    }

    @Override
    protected int[] slotsTop() {
        return new int[]{0, 2, 4, 5, 6};
    }

    @Override
    protected int[] slotsBottom() {
        return new int[]{1, 3};
    }

    @Override
    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    @Override
    public List<ItemStack> getOutputs() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }

    @Override
    public int func_70302_i_() {
        return 7;
    }

    @Override
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFluidProcessor(this, playerInventory);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
            case 3: {
                return this.cap.milkID;
            }
            case 4: {
                return this.cap.sugarID;
            }
            case 5: {
                return this.milkCount;
            }
            case 6: {
                return this.sugarCount;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
                break;
            }
            case 3: {
                this.cap.milkID = (byte)value;
                break;
            }
            case 4: {
                this.cap.sugarID = (byte)value;
                break;
            }
            case 5: {
                this.milkCount = value;
                break;
            }
            case 6: {
                this.sugarCount = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 7;
    }

    @Override
    public String func_174875_k() {
        return "dcs_climate:fluidprocessor_steel";
    }

    @Override
    public String func_70005_c_() {
        return "dcs.gui.device.teapot";
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY) {
            return (T)this.cap;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.milkCount = tag.func_74762_e("MilkCount");
        this.sugarCount = tag.func_74762_e("SugarCount");
        this.cap = this.cap.readFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("MilkCount", this.milkCount);
        tag.func_74768_a("SugarCount", this.sugarCount);
        this.cap.writeToNBT(tag);
        return tag;
    }

    @Override
    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("MilkCount", this.milkCount);
        tag.func_74768_a("SugarCount", this.sugarCount);
        this.cap.writeToNBT(tag);
        return tag;
    }

    @Override
    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.milkCount = tag.func_74762_e("MilkCount");
        this.sugarCount = tag.func_74762_e("SugarCount");
        this.cap = this.cap.readFromNBT(tag);
    }
}

