/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.base.ClimateDoubleCropBase;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.food.FoodInit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCoffee
extends ClimateDoubleCropBase
implements ITexturePath {
    public BlockCoffee(String s) {
        super(Material.field_151585_k, s, 3);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149752_b(3.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROP_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta & 7;
        boolean d = meta > 7;
        boolean shrub = m < 4;
        String b = "dcs_climate:blocks/crop/";
        String db = d ? "_under" : "_upper";
        return shrub ? b + "shrub_" + m : b + "coffee_" + m + db;
    }

    public static List<String> getTexList() {
        ArrayList<String> list = new ArrayList<String>();
        String b = "dcs_climate:blocks/crop/";
        list.add(b + "coffee_4_upper");
        list.add(b + "coffee_5_upper");
        list.add(b + "coffee_6_upper");
        list.add(b + "coffee_7_upper");
        list.add(b + "coffee_4_under");
        list.add(b + "coffee_5_under");
        list.add(b + "coffee_6_under");
        list.add(b + "coffee_7_under");
        return list;
    }

    public String getTexPath(int meta, boolean isFull) {
        int m = meta & 7;
        boolean d = meta > 7;
        boolean shrub = m < 4;
        String b = "dcs_climate:blocks/crop/";
        String db = d ? "_under" : "_upper";
        return shrub ? b + "shrub_" + m : b + "coffee_" + m + db;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        return new ItemStack(FoodInit.seeds, 1, 4);
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int i = 1 + this.rand.nextInt(1 + fortune);
        list.add(new ItemStack(FoodInit.crops, i, 4));
        return list;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        ret.add(DCHeatTier.HOT);
        ret.add(DCHeatTier.BOIL);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.NORMAL);
        ret.add(DCHumidity.WET);
        return ret;
    }

    public List<DCHeatTier> getHardmodeTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.WARM);
        return ret;
    }

    public List<DCAirflow> getHardmodeAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.NORMAL);
        ret.add(DCAirflow.FLOW);
        return ret;
    }
}

