/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.EnumSeason;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.config.CoreConfigDC;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.base.INameSuffix;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrape
extends BlockDC
implements INameSuffix,
IClimateCrop,
IRapidCollectables,
IGrowable,
IPlantable {
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyBool GROUND = PropertyBool.func_177716_a((String)"ground");
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyDirection FACING2 = PropertyDirection.func_177714_a((String)"facing");
    protected Random cropRand = new Random();

    public BlockGrape(String s) {
        super(Material.field_151585_k, s);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING2, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149738_a(World world) {
        return 150;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public List<ItemStack> getSubItemList() {
        List list = super.getSubItemList();
        list.add(new ItemStack((Block)this, 1, 3));
        return list;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            IBlockState crop = world.func_180495_p(pos);
            ItemStack held = player.field_71071_by.func_70448_g();
            if (!DCUtil.isEmpty((ItemStack)held) && held.func_77973_b() == Items.field_151100_aR && held.func_77952_i() == 15) {
                ItemDye.applyBonemeal((ItemStack)held, (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
            if (this.harvest(world, pos, crop, player)) {
                player.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (state.func_177230_c() == this) {
            int chance;
            IClimate clm = this.getClimate(world, pos, state);
            int n = chance = this.isSuitableClimate(clm, state) ? 8 : 32;
            if (rand.nextInt(chance) == 0) {
                this.grow(world, pos, state);
            }
        }
    }

    protected IClimate getClimate(World world, BlockPos pos, IBlockState state) {
        DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(world, pos, this.checkingRange()[0], false);
        DCHumidity hum = ClimateAPI.calculator.getHumidity(world, pos.func_177977_b(), this.checkingRange()[1], false);
        DCAirflow air = ClimateAPI.calculator.getAirflow(world, pos, this.checkingRange()[2], false);
        IClimate c = ClimateAPI.register.getClimateFromParam(heat, hum, air);
        return c;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        GrowingStage stage = this.getCurrentStage(state);
        ret.add(this.getSeedItem(state));
        if (stage == GrowingStage.GROWN) {
            ret.addAll(this.getCropItems(state, fortune));
        }
        return ret;
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        return this.isSuitablePlace(worldIn, pos, worldIn.func_180495_p(pos.func_177977_b()));
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        if (!this.canBlockStay(world, pos, state)) {
            world.func_175655_b(pos, true);
        }
    }

    protected float getSeedDropChance() {
        return 1.0f;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int s = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.STAGE4);
        if (s < 0) {
            s = 0;
        }
        return new ItemStack((Block)this, 1, s);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (DCState.getBool((IBlockState)(state = this.func_176221_a(state, source, pos)), (PropertyBool)TOP)) {
            return UP_AABB;
        }
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING2);
        switch (face) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return Block.field_185505_j;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public ItemStack getSeedItem(IBlockState state) {
        ItemStack item = new ItemStack(FoodInit.seeds, 1, 16);
        return item;
    }

    public List<ItemStack> getCropItems(IBlockState state, int fortune) {
        ArrayList ret = Lists.newArrayList();
        int i = 1 + MathHelper.func_76141_d((float)((float)this.cropRand.nextInt(1 + fortune) / 2.0f));
        ret.add(new ItemStack(FoodInit.crops, i, 20));
        return ret;
    }

    public IBlockState getGrownState() {
        return this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(3));
    }

    public IBlockState setGroundState(IBlockState state) {
        return state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0));
    }

    public boolean isSuitableClimate(IClimate climate, IBlockState thisState) {
        if (climate == null || thisState == null || thisState.func_177230_c() != this) {
            return false;
        }
        boolean temp = this.getSuitableTemp(thisState).contains(climate.getHeat());
        boolean hum = this.getSuitableHum(thisState).contains(climate.getHumidity());
        boolean air = this.getSuitableAir(thisState).contains(climate.getAirflow());
        return temp && hum && air;
    }

    protected boolean isSoil(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this || this.isSuitableMaterial(state.func_185904_a()) || world.func_180495_p(pos).func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this);
    }

    protected boolean isSuitableMaterial(Material mat) {
        return mat == Material.field_151577_b || mat == Material.field_151578_c || mat == Material.field_151595_p;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState targetState) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IBlockState check;
            if (face == EnumFacing.DOWN || world.func_175623_d(pos.func_177972_a(face)) || (check = world.func_180495_p(pos.func_177972_a(face))).func_185904_a() == Material.field_151585_k || check.func_185904_a().func_76222_j()) continue;
            return true;
        }
        return this.isSoil(world, pos.func_177977_b());
    }

    public GrowingStage getCurrentStage(IBlockState thisState) {
        if (thisState == null) {
            return GrowingStage.DEAD;
        }
        int i = DCState.getInt((IBlockState)thisState, (PropertyInteger)DCState.STAGE4);
        if (i == 3) {
            return GrowingStage.GROWN;
        }
        if (i == 2) {
            return GrowingStage.FLOWER;
        }
        if (i == 1) {
            return GrowingStage.YOUNG;
        }
        return GrowingStage.GROUND;
    }

    public boolean grow(World world, BlockPos pos, IBlockState state) {
        if (state != null && state.func_177230_c() == this && world.func_175699_k(pos) > 7) {
            EnumSeason season = DCTimeHelper.getSeasonEnum((World)world);
            if (!DCState.getBool((IBlockState)state, (PropertyBool)GROUND)) {
                IBlockState newstate;
                int stage = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.STAGE4);
                if (stage == 3) {
                    return false;
                }
                if (stage >= 1) {
                    if (!ModuleConfig.crop || season != EnumSeason.SPRING && season != EnumSeason.WINTER) {
                        newstate = state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(stage + 1));
                        world.func_180501_a(pos, newstate, 2);
                    }
                } else if (!(stage >= 1 || ModuleConfig.crop && season == EnumSeason.WINTER)) {
                    newstate = state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(stage + 1));
                    world.func_180501_a(pos, newstate, 2);
                }
            }
            if (!ModuleConfig.crop || season != EnumSeason.WINTER) {
                IBlockState state2;
                EnumFacing f = EnumFacing.UP;
                if (!DCState.getBool((IBlockState)state, (PropertyBool)GROUND)) {
                    int i = this.cropRand.nextInt(6);
                    f = EnumFacing.field_82609_l[i];
                }
                if (this.isGrowableHeight(world, pos, state2 = this.func_176221_a(state, (IBlockAccess)world, pos))) {
                    if (f == EnumFacing.DOWN) {
                        EnumFacing side = (EnumFacing)state2.func_177229_b((IProperty)FACING2);
                        if (side.func_176740_k().func_176722_c() && world.func_175623_d(pos.func_177984_a().func_177972_a(side)) && this.isGrowablePlace(world, pos.func_177984_a().func_177972_a(side))) {
                            IBlockState newstate = this.func_176223_P();
                            world.func_180501_a(pos.func_177984_a().func_177972_a(side), newstate, 2);
                        }
                    } else if (world.func_175623_d(pos.func_177972_a(f)) && this.isGrowablePlace(world, pos.func_177972_a(f))) {
                        IBlockState newstate = this.func_176223_P();
                        world.func_180501_a(pos.func_177972_a(f), newstate, 2);
                    }
                }
            }
        }
        return false;
    }

    public boolean isGrowableHeight(World world, BlockPos pos, IBlockState state) {
        if (DCState.getBool((IBlockState)state, (PropertyBool)GROUND)) {
            return true;
        }
        for (int h = 1; h < 4; ++h) {
            for (BlockPos p : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, -h, -1), (BlockPos)pos.func_177982_a(1, -h, 1))) {
                if (!this.isSuitableMaterial(world.func_180495_p(p).func_185904_a())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGrowablePlace(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IBlockState check;
            if (face == EnumFacing.DOWN || world.func_175623_d(pos.func_177972_a(face)) || (check = world.func_180495_p(pos.func_177972_a(face))).func_185904_a() == Material.field_151585_k || check.func_185904_a().func_76222_j()) continue;
            return true;
        }
        return false;
    }

    public boolean harvest(World world, BlockPos pos, IBlockState thisState, EntityPlayer player) {
        GrowingStage stage;
        if (thisState != null && thisState.func_177230_c() == this && (stage = this.getCurrentStage(thisState)) == GrowingStage.GROWN) {
            int f = 0;
            if (player != null && !DCUtil.isEmpty((ItemStack)player.func_184607_cu())) {
                f = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184607_cu());
            }
            List<ItemStack> crops = this.getCropItems(thisState, f);
            boolean ret = false;
            for (ItemStack item : crops) {
                EntityItem drop = new EntityItem(world);
                drop.func_92058_a(item);
                if (player != null) {
                    drop.func_70107_b(player.field_70165_t, player.field_70163_u + 0.15, player.field_70161_v);
                } else {
                    drop.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)drop);
                }
                ret = true;
            }
            if (ret) {
                IBlockState next = thisState.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0));
                world.func_180501_a(pos, next, 2);
            }
            return ret;
        }
        return false;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public int[] checkingRange() {
        return CoreConfigDC.ranges;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COLD);
        ret.add(DCHeatTier.COOL);
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        return CoreConfigDC.harderCrop ? this.getHardmodeTemp(thisState) : ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.DRY);
        ret.add(DCHumidity.NORMAL);
        return CoreConfigDC.harderCrop ? this.getHardmodeHum(thisState) : ret;
    }

    public List<DCAirflow> getSuitableAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.NORMAL);
        ret.add(DCAirflow.FLOW);
        ret.add(DCAirflow.WIND);
        return CoreConfigDC.harderCrop ? this.getHardmodeAir(thisState) : ret;
    }

    public List<DCHeatTier> getHardmodeTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.NORMAL);
        return ret;
    }

    public List<DCHumidity> getHardmodeHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.NORMAL);
        return ret;
    }

    public List<DCAirflow> getHardmodeAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.NORMAL);
        ret.add(DCAirflow.FLOW);
        return ret;
    }

    public String getCollectableTool() {
        return "shears";
    }

    public boolean isCollectable(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return false;
        }
        return item.func_77973_b() instanceof ItemShears;
    }

    public int getCollectArea(ItemStack item) {
        return 3;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        return this.harvest(world, pos, state, player);
    }

    public String[] getNameSuffix() {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return this.getSeedItem(state).func_77952_i();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getSeedItem(state).func_77973_b();
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        if (i > 3) {
            i = 3;
        }
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(i));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = (Integer)state.func_177229_b((IProperty)DCState.STAGE4);
        if (i > 3) {
            i = 3;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean up = !world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151585_k;
        boolean down = this.isSuitableMaterial(world.func_180495_p(pos.func_177977_b()).func_185904_a());
        EnumFacing f = EnumFacing.DOWN;
        if (up) {
            f = EnumFacing.UP;
        }
        for (EnumFacing f2 : EnumFacing.field_176754_o) {
            if (world.func_175623_d(pos.func_177972_a(f2)) || world.func_180495_p(pos.func_177972_a(f2)).func_185904_a() == Material.field_151585_k || world.func_180495_p(pos.func_177972_a(f2)).func_185904_a().func_76222_j()) continue;
            f = f2;
            break;
        }
        return state.func_177226_a((IProperty)FACING2, (Comparable)f).func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(down)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(up));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROUND, FACING2, DCState.STAGE4, TOP});
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (state != null && state.func_177230_c() == this) {
            GrowingStage stage = this.getCurrentStage(state);
            IClimate clm = this.getClimate(world, pos, state);
            return this.isSuitableClimate(clm, state) && stage.canUseBonemeal();
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        if (state != null && state.func_177230_c() == this) {
            GrowingStage stage = this.getCurrentStage(state);
            return stage.canUseBonemeal();
        }
        return false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }
}

