/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.food.FoodInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLeavesDatesCrop
extends ClimateCropBase
implements ITexturePath {
    public static final PropertyBool DECAYABLE = PropertyBool.func_177716_a((String)"decayable");
    public static final PropertyBool CHECK_DECAY = PropertyBool.func_177716_a((String)"check_decay");
    private final Random leavesRand = new Random();

    public BlockLeavesDatesCrop(String s) {
        super(Material.field_151584_j, s, 3);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DECAYABLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149738_a(World world) {
        return 200;
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta & 3;
        String b = "dcs_climate:blocks/crop/";
        return b + "datescrop_" + m;
    }

    public static List<String> getTexList() {
        ArrayList<String> list = new ArrayList<String>();
        String b = "dcs_climate:blocks/crop/";
        list.add(b + "datescrop_0");
        list.add(b + "datescrop_1");
        list.add(b + "datescrop_2");
        list.add(b + "datescrop_3");
        return list;
    }

    public String getTexPath(int meta, boolean isFull) {
        int m = meta & 3;
        String b = "dcs_climate:items/block/crop/";
        return b + "datescrop_" + m;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        return new ItemStack(FoodInit.saplings2, 1, 1);
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int i = 2 + this.cropRand.nextInt(2 + fortune);
        list.add(new ItemStack(FoodInit.crops, i, 17));
        return list;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState stateIn) {
        IBlockState state = world.func_180495_p(pos);
        if (!world.field_72995_K && state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue()) {
            int i = 0;
            int j = i + 1;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            boolean hasLog = false;
            if (world.func_175707_a(new BlockPos(x - j, y - j, z - j), new BlockPos(x + j, y + j, z + j))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int x1 = -i; x1 <= i; ++x1) {
                    for (int y1 = -i; y1 <= i; ++y1) {
                        for (int z1 = -i; z1 <= i; ++z1) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(x + x1, y + y1, z + z1));
                            Block block = iblockstate.func_177230_c();
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(x + x1, y + y1, z + z1))) continue;
                            hasLog = true;
                        }
                    }
                }
            }
            if (hasLog) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 4);
                return true;
            }
            this.destroy(world, pos);
            return false;
        }
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    protected float getSeedDropChance() {
        return 0.2f;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        boolean d = (meta & 4) > 0;
        boolean c = (meta & 8) > 0;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)DECAYABLE, (Comparable)Boolean.valueOf(d)).func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(c));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = (Integer)state.func_177229_b((IProperty)DCState.STAGE4);
        if (((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue()) {
            i += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue()) {
            i += 8;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.STAGE4, DECAYABLE, CHECK_DECAY});
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        ret.add(DCHeatTier.HOT);
        ret.add(DCHeatTier.BOIL);
        ret.add(DCHeatTier.OVEN);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.DRY);
        ret.add(DCHumidity.NORMAL);
        ret.add(DCHumidity.WET);
        return ret;
    }

    public List<DCHeatTier> getHardmodeTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.WARM);
        ret.add(DCHeatTier.HOT);
        return ret;
    }

    public List<DCHumidity> getHardmodeHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.DRY);
        return ret;
    }

    public List<DCAirflow> getHardmodeAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.NORMAL);
        ret.add(DCAirflow.FLOW);
        return ret;
    }
}

