/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.food.FoodInit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockLeavesTea
extends ClimateCropBase
implements ITexturePath,
IShearable {
    public BlockLeavesTea(String s) {
        super(Material.field_151585_k, s, 3);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149752_b(3.0f);
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta > 0 ? 1 : 0;
        String b = "dcs_climate:blocks/crop/";
        return b + "tea_" + m;
    }

    public static List<String> getTexList() {
        ArrayList<String> list = new ArrayList<String>();
        String b = "dcs_climate:blocks/crop/";
        list.add(b + "tea_0");
        list.add(b + "tea_1");
        return list;
    }

    public String getTexPath(int meta, boolean isFull) {
        int m = meta > 0 ? 1 : 0;
        String b = "dcs_climate:items/block/crop/";
        return b + "tea_" + m;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        return new ItemStack(FoodInit.saplings, 1, 2);
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(FoodInit.crops, 1, 8));
        return list;
    }

    public IBlockState getGrownState() {
        return this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(1));
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 1));
        return list;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((Block)this, 1, 0));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState state) {
        if (state == null) {
            return false;
        }
        return state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151578_c;
    }

    public GrowingStage getCurrentStage(IBlockState thisState) {
        if (thisState == null) {
            return GrowingStage.DEAD;
        }
        if (DCState.getInt((IBlockState)thisState, (PropertyInteger)DCState.STAGE4) > 0) {
            return GrowingStage.GROWN;
        }
        return GrowingStage.YOUNG;
    }

    public boolean grow(World world, BlockPos pos, IBlockState thisState) {
        if (thisState != null && thisState.func_177230_c() instanceof ClimateCropBase) {
            GrowingStage stage = this.getCurrentStage(thisState);
            if (stage == GrowingStage.DEAD) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                return false;
            }
            if (stage == GrowingStage.GROWN) {
                return false;
            }
            if (DCState.getInt((IBlockState)thisState, (PropertyInteger)DCState.STAGE4) == 0) {
                IBlockState next = this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(1));
                return world.func_180501_a(pos, next, 3);
            }
        }
        return false;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COOL);
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        ret.add(DCHeatTier.HOT);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.NORMAL);
        ret.add(DCHumidity.WET);
        return ret;
    }

    public List<DCAirflow> getSuitableAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.FLOW);
        ret.add(DCAirflow.WIND);
        return ret;
    }

    public List<DCHeatTier> getHardmodeTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.NORMAL);
        return ret;
    }

    public List<DCHumidity> getHardmodeHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.NORMAL);
        return ret;
    }

    public List<DCAirflow> getHardmodeAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.FLOW);
        return ret;
    }
}

