/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.food.FoodInit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockLettuce
extends ClimateCropBase
implements ITexturePath {
    protected static final AxisAlignedBB BUD_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);

    public BlockLettuce(String s) {
        super(Material.field_151585_k, s, 3);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149752_b(3.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.STAGE4);
        return i < 2 ? BUD_AABB : CROP_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta & 3;
        String b = "dcs_climate:blocks/crop/";
        return b + "lettuce_" + m;
    }

    public static List<String> getTexList() {
        ArrayList<String> list = new ArrayList<String>();
        String b = "dcs_climate:blocks/crop/";
        list.add(b + "lettuce_0");
        list.add(b + "lettuce_1");
        list.add(b + "lettuce_2");
        list.add(b + "lettuce_3");
        return list;
    }

    public String getTexPath(int meta, boolean isFull) {
        int m = meta & 3;
        String b = "dcs_climate:items/block/crop/";
        return b + "lettuce_" + m;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        int i = 1;
        if (this.getCurrentStage(thisState) == GrowingStage.GROWN) {
            i = 1 + this.cropRand.nextInt(2);
        }
        return new ItemStack(FoodInit.seeds, i, 13);
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(FoodInit.crops, 1, 15));
        return list;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COLD);
        ret.add(DCHeatTier.COOL);
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.NORMAL);
        ret.add(DCHumidity.WET);
        return ret;
    }

    public List<DCHeatTier> getHardmodeTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COOL);
        return ret;
    }

    public List<DCAirflow> getHardmodeAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.FLOW);
        return ret;
    }
}

