/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.EnumSeason;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.config.CoreConfigDC;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.base.INameSuffix;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.crop.BlockLotusN;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Deprecated
public class BlockLotus
extends BlockDC
implements INameSuffix,
IClimateCrop,
IRapidCollectables,
IGrowable {
    public static final PropertyBool BLACK = PropertyBool.func_177716_a((String)"black");
    protected Random cropRand = new Random();

    public BlockLotus(String s, int max) {
        super(Material.field_151586_h, s);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BLACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean isInWater(IBlockAccess world, BlockPos pos) {
        boolean ret = true;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            IBlockState target = world.func_180495_p(pos.func_177972_a(face));
            if (target.func_177230_c() instanceof BlockLiquid && target.func_185904_a() == Material.field_151586_h || target.func_177230_c() == this || target.func_177230_c().isSideSolid(target, world, pos.func_177972_a(face), face.func_176734_d())) continue;
            ret = false;
        }
        return ret;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149738_a(World world) {
        return 80;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public List<ItemStack> getSubItemList() {
        List list = super.getSubItemList();
        list.add(new ItemStack((Block)this, 1, 3));
        return list;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            IBlockState crop = world.func_180495_p(pos);
            int stage = (Integer)state.func_177229_b((IProperty)DCState.STAGE8);
            ItemStack held = player.field_71071_by.func_70448_g();
            if (!DCUtil.isEmpty((ItemStack)held) && held.func_77973_b() == Items.field_151100_aR && held.func_77952_i() == 15) {
                ItemDye.applyBonemeal((ItemStack)held, (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
            if (stage > 3) {
                player.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
                return this.harvest(world, pos, crop, player);
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K && state != null && state.func_177230_c() == this) {
            int stage = (Integer)state.func_177229_b((IProperty)DCState.STAGE8);
            boolean black = (Boolean)state.func_177229_b((IProperty)BLACK);
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
            world.func_180501_a(pos.func_177977_b(), FoodInit.cropLotusN.func_176223_P().func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(stage)).func_177226_a((IProperty)BlockLotusN.BLACK, (Comparable)Boolean.valueOf(black)), 2);
        }
    }

    protected IClimate getClimate(World world, BlockPos pos, IBlockState state) {
        DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(world, pos, this.checkingRange()[0], false);
        DCHumidity hum = ClimateAPI.calculator.getHumidity(world, pos.func_177977_b(), this.checkingRange()[1], false);
        DCAirflow air = ClimateAPI.calculator.getAirflow(world, pos, this.checkingRange()[2], false);
        IClimate c = ClimateAPI.register.getClimateFromParam(heat, hum, air);
        return c;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.cropRand.nextFloat() <= this.getSeedDropChance()) {
            ret.add(this.getSeedItem(state));
        }
        ret.addAll(this.getCropItems(state, fortune));
        return ret;
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        return this.isSuitablePlace(worldIn, pos.func_177977_b(), worldIn.func_180495_p(pos.func_177977_b()));
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        world.func_180497_b(pos, block, 10, 0);
    }

    protected float getSeedDropChance() {
        return 1.0f;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        ItemStack item = new ItemStack(FoodInit.seeds, 1, 6);
        return item;
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList ret = Lists.newArrayList();
        int stage = (Integer)thisState.func_177229_b((IProperty)DCState.STAGE8);
        boolean black = (Boolean)thisState.func_177229_b((IProperty)BLACK);
        int count = 1;
        if (fortune > 0) {
            count += this.cropRand.nextInt(fortune);
        }
        if (stage == 7) {
            ret.add(new ItemStack(FoodInit.seeds, count + 2, 6));
        } else if (stage == 6) {
            if (black) {
                ret.add(new ItemStack(FoodInit.petals, 1, 1));
                ret.add(new ItemStack(FoodInit.crops, count, 10));
            } else {
                ret.add(new ItemStack(FoodInit.petals, 1, 0));
                ret.add(new ItemStack(FoodInit.crops, count, 10));
            }
        } else if (stage == 5 || stage == 4) {
            if (black) {
                ret.add(new ItemStack(FoodInit.petals, count, 1));
            } else {
                ret.add(new ItemStack(FoodInit.petals, count, 0));
            }
        }
        return ret;
    }

    public IBlockState getGrownState() {
        return this.func_176223_P().func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(6));
    }

    public IBlockState setGroundState(IBlockState state) {
        return state.func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(0));
    }

    public boolean isSuitableClimate(IClimate climate, IBlockState thisState) {
        if (climate == null || thisState == null || thisState.func_177230_c() != this) {
            return false;
        }
        boolean temp = this.getSuitableTemp(thisState).contains(climate.getHeat());
        boolean hum = this.getSuitableHum(thisState).contains(climate.getHumidity());
        boolean air = this.getSuitableAir(thisState).contains(climate.getAirflow());
        return temp && hum && air;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState targetState) {
        if (targetState == null) {
            return false;
        }
        boolean water = this.isInWater((IBlockAccess)world, pos.func_177984_a());
        boolean soil = targetState.func_185904_a() == Material.field_151578_c || targetState.func_185904_a() == Material.field_151577_b;
        boolean air = world.func_175623_d(pos.func_177981_b(2));
        return water && soil && air;
    }

    public GrowingStage getCurrentStage(IBlockState thisState) {
        if (thisState == null) {
            return GrowingStage.DEAD;
        }
        int i = DCState.getInt((IBlockState)thisState, (PropertyInteger)DCState.STAGE8);
        if (i == 7) {
            return GrowingStage.DEAD;
        }
        if (i == 6) {
            return GrowingStage.GROWN;
        }
        if (i > 3) {
            return GrowingStage.FLOWER;
        }
        return GrowingStage.YOUNG;
    }

    public boolean grow(World world, BlockPos pos, IBlockState state) {
        if (state != null && state.func_177230_c() == this) {
            int stage = (Integer)state.func_177229_b((IProperty)DCState.STAGE8);
            boolean black = (Boolean)state.func_177229_b((IProperty)BLACK);
            boolean water = this.isInWater((IBlockAccess)world, pos);
            if (water && stage < 7) {
                EnumSeason season = DCTimeHelper.getSeasonEnum((World)world);
                int next = stage;
                if (stage == 6 && season.id > 2) {
                    next = stage + 1;
                } else if (stage == 5 && season.id > 1) {
                    next = stage + 1;
                } else if (!(stage != 4 && stage != 3 || season.id != 1 && season.id != 2)) {
                    next = stage + 1;
                } else if (stage < 3 && season.id < 3) {
                    if (world.field_73012_v.nextInt(50) == 0) {
                        black = true;
                    }
                    next = stage + 1;
                } else if (stage > 1 && season.id == 3) {
                    next = 7;
                }
                if (next > stage) {
                    IBlockState newstate = state.func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(next)).func_177226_a((IProperty)BLACK, (Comparable)Boolean.valueOf(black));
                    return world.func_180501_a(pos, newstate, 2);
                }
            }
        }
        return false;
    }

    public boolean harvest(World world, BlockPos pos, IBlockState thisState, EntityPlayer player) {
        int stage;
        if (thisState != null && thisState.func_177230_c() == this && (stage = ((Integer)thisState.func_177229_b((IProperty)DCState.STAGE8)).intValue()) > 3) {
            int f = 0;
            if (player != null && !DCUtil.isEmpty((ItemStack)player.func_184607_cu())) {
                f = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184607_cu());
            }
            List<ItemStack> crops = this.getCropItems(thisState, f);
            boolean ret = false;
            for (ItemStack item : crops) {
                EntityItem drop = new EntityItem(world);
                drop.func_92058_a(item);
                if (player != null) {
                    drop.func_70107_b(player.field_70165_t, player.field_70163_u + 0.15, player.field_70161_v);
                } else {
                    drop.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)drop);
                }
                ret = true;
            }
            if (ret) {
                if (stage == 7) {
                    boolean air = !this.isInWater((IBlockAccess)world, pos);
                    world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
                } else {
                    IBlockState next = thisState.func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(2));
                    world.func_180501_a(pos, next, 2);
                }
            }
            return ret;
        }
        return false;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public int[] checkingRange() {
        return CoreConfigDC.ranges;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        ret.add(DCHeatTier.HOT);
        ret.add(DCHeatTier.BOIL);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.WET);
        ret.add(DCHumidity.UNDERWATER);
        return ret;
    }

    public List<DCAirflow> getSuitableAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.TIGHT);
        ret.add(DCAirflow.NORMAL);
        ret.add(DCAirflow.FLOW);
        ret.add(DCAirflow.WIND);
        return ret;
    }

    public String getCollectableTool() {
        return "shears";
    }

    public boolean isCollectable(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return false;
        }
        return item.func_77973_b() instanceof ItemShears;
    }

    public int getCollectArea(ItemStack item) {
        return 3;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        return this.harvest(world, pos, state, player);
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 7;
        boolean j = meta > 7;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.STAGE8, (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)BLACK, (Comparable)Boolean.valueOf(j));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        int j = 0;
        i = (Integer)state.func_177229_b((IProperty)DCState.STAGE8);
        j = (Boolean)state.func_177229_b((IProperty)BLACK) != false ? 8 : 0;
        return i + j;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.STAGE8, BLACK, BlockFluidBase.LEVEL});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (!DCUtil.isEmpty((ItemStack)this.getSeedItem(state))) {
            return this.getSeedItem(state).func_77973_b();
        }
        return null;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        int stage = (Integer)state.func_177229_b((IProperty)DCState.STAGE8);
        IClimate clm = this.getClimate(world, pos, state);
        return this.isSuitableClimate(clm, state) && stage > -1 && stage < 7;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        int stage = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.STAGE8);
        return stage > -1 && stage < 7;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state);
    }

    public String[] getNameSuffix() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = this.func_176201_c(state);
        if (meta >= 0) {
            return new ItemStack((Block)this, 1, meta);
        }
        return this.func_185473_a(world, pos, state);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

