/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.worldgen.WorldGenDCPalmTree;
import defeatedcrow.hac.main.worldgen.WorldGenDCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockSaplingDC2
extends ClimateCropBase
implements ITexturePath,
IPlantable {
    public BlockSaplingDC2(String s) {
        super(Material.field_151585_k, s, 3);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149752_b(3.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROP_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta & 3;
        String b = "dcs_climate:blocks/crop/sapling_";
        switch (m) {
            case 0: {
                return b + "walnut";
            }
            case 1: {
                return b + "dates";
            }
        }
        return b + "walnut";
    }

    public static List<String> getTexList() {
        ArrayList<String> list = new ArrayList<String>();
        String b = "dcs_climate:blocks/crop/";
        list.add(b + "sapling_walnut");
        list.add(b + "sapling_dates");
        return list;
    }

    public String getTexPath(int meta, boolean isFull) {
        int m = meta & 3;
        String b = "dcs_climate:items/block/crop/sapling_";
        switch (m) {
            case 0: {
                return b + "walnut";
            }
            case 1: {
                return b + "dates";
            }
        }
        return b + "walnut";
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        int m = (Integer)thisState.func_177229_b((IProperty)DCState.STAGE4);
        return new ItemStack(FoodInit.saplings2, 1, m);
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        return list;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
        return list;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.isSuitablePlace(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState targetState) {
        if (targetState == null) {
            return false;
        }
        return targetState.func_185904_a() == Material.field_151577_b || targetState.func_185904_a() == Material.field_151578_c || targetState.func_185904_a() == Material.field_151595_p || targetState.func_185904_a() == Material.field_151578_c || targetState.func_177230_c().canSustainPlant(targetState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this);
    }

    public GrowingStage getCurrentStage(IBlockState thisState) {
        return GrowingStage.YOUNG;
    }

    public boolean grow(World world, BlockPos pos, IBlockState thisState) {
        if (thisState != null && thisState.func_177230_c() instanceof ClimateCropBase) {
            if (!TerrainGen.saplingGrowTree((World)world, (Random)this.cropRand, (BlockPos)pos)) {
                return false;
            }
            int meta = (Integer)thisState.func_177229_b((IProperty)DCState.STAGE4);
            IBlockState log = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
            WorldGenAbstractTree gen = null;
            if (meta == 0) {
                IBlockState leaves = FoodInit.leavesWalnut.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
                gen = new WorldGenDCTree(true, leaves, log, 6);
            } else if (meta == 1) {
                IBlockState leaves = FoodInit.leavesDates.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
                IBlockState leaves2 = FoodInit.leavesDatesCrop.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
                gen = new WorldGenDCPalmTree(true, leaves, leaves2, 6);
                log = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
            }
            if (gen != null && gen.func_180709_b(world, this.cropRand, pos)) {
                world.func_180501_a(pos, log, 3);
                return true;
            }
        }
        return false;
    }

    public boolean harvest(World world, BlockPos pos, IBlockState thisState, EntityPlayer player) {
        return false;
    }

    public boolean isCollectable(ItemStack item) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COOL);
        ret.add(DCHeatTier.COLD);
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.HOT);
        ret.add(DCHeatTier.WARM);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.DRY);
        ret.add(DCHumidity.NORMAL);
        ret.add(DCHumidity.WET);
        return ret;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }
}

