/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block.crop;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.api.placeable.IRapidCollectables;
import defeatedcrow.hac.api.placeable.ISidedTexture;
import defeatedcrow.hac.config.CoreConfigDC;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.base.INameSuffix;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSeaweed
extends BlockDC
implements ISidedTexture,
INameSuffix,
IClimateCrop,
IGrowable,
IRapidCollectables {
    protected Random cropRand = new Random();

    public BlockSeaweed(String s, int max) {
        super(Material.field_151586_h, s);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean isInWater(IBlockAccess world, BlockPos pos) {
        boolean ret = true;
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            IBlockState target = world.func_180495_p(pos.func_177972_a(face));
            if (target.func_185904_a() == Material.field_151586_h || target.func_177230_c().isSideSolid(target, world, pos.func_177972_a(face), face.func_176734_d())) continue;
            ret = false;
        }
        return ret;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149738_a(World world) {
        return 80;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public List<ItemStack> getSubItemList() {
        List list = super.getSubItemList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            IBlockState crop = world.func_180495_p(pos);
            ItemStack held = player.field_71071_by.func_70448_g();
            if (!DCUtil.isEmpty((ItemStack)held) && held.func_77973_b() == Items.field_151100_aR && held.func_77952_i() == 15) {
                ItemDye.applyBonemeal((ItemStack)held, (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
            if (this.harvest(world, pos, crop, player)) {
                player.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (state.func_177230_c() == this && this.checkAndDropBlock(world, pos, state)) {
            int chance;
            IClimate clm = this.getClimate(world, pos, state);
            int n = chance = this.isSuitableClimate(clm, state) ? 8 : 30;
            if (rand.nextInt(chance) == 0) {
                this.grow(world, pos, state);
            }
        }
    }

    protected IClimate getClimate(World world, BlockPos pos, IBlockState state) {
        DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(world, pos, this.checkingRange()[0], false);
        DCHumidity hum = ClimateAPI.calculator.getHumidity(world, pos.func_177977_b(), this.checkingRange()[1], false);
        DCAirflow air = ClimateAPI.calculator.getAirflow(world, pos, this.checkingRange()[2], false);
        IClimate c = ClimateAPI.register.getClimateFromParam(heat, hum, air);
        return c;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getCropItems(state, fortune));
        return ret;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.isSuitablePlace(worldIn, pos, worldIn.func_180495_p(pos));
    }

    protected boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        worldIn.func_190524_a(pos.func_177984_a(), (Block)Blocks.field_150355_j, pos);
        return false;
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        this.checkAndDropBlock(world, pos, state);
    }

    protected float getSeedDropChance() {
        return 1.0f;
    }

    public ItemStack getSeedItem(IBlockState thisState) {
        ItemStack item = new ItemStack(FoodInit.seeds, 1, 8);
        return item;
    }

    public List<ItemStack> getCropItems(IBlockState thisState, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack(FoodInit.seeds, 1, 8));
        return ret;
    }

    public IBlockState getGrownState() {
        return this.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(2));
    }

    public IBlockState setGroundState(IBlockState state) {
        return state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(0));
    }

    public boolean isSuitableClimate(IClimate climate, IBlockState thisState) {
        if (climate == null || thisState == null || thisState.func_177230_c() != this) {
            return false;
        }
        boolean temp = this.getSuitableTemp(thisState).contains(climate.getHeat());
        boolean hum = this.getSuitableHum(thisState).contains(climate.getHumidity());
        boolean air = this.getSuitableAir(thisState).contains(climate.getAirflow());
        return temp && hum && air;
    }

    protected boolean isSoil(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        boolean soil = state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || state.func_177230_c() == this;
        return soil;
    }

    public boolean isSuitablePlace(World world, BlockPos pos, IBlockState targetState) {
        boolean water = this.isInWater((IBlockAccess)world, pos);
        boolean soil = this.isSoil(world, pos.func_177977_b());
        return water && soil;
    }

    public GrowingStage getCurrentStage(IBlockState thisState) {
        if (thisState == null) {
            return GrowingStage.DEAD;
        }
        int i = DCState.getInt((IBlockState)thisState, (PropertyInteger)DCState.STAGE4);
        if (i == 0) {
            return GrowingStage.GROUND;
        }
        return GrowingStage.GROWN;
    }

    public boolean grow(World world, BlockPos pos, IBlockState state) {
        if (state != null && state.func_177230_c() == this) {
            boolean gl;
            int l = 1;
            int i = 1;
            while (pos.func_177956_o() - i < 1) {
                BlockPos check = pos.func_177981_b(i);
                if (world.func_180495_p(check).func_177230_c() != this) {
                    l = i - 1;
                    break;
                }
                ++i;
            }
            if (l > 63) {
                return false;
            }
            boolean water = this.isInWater((IBlockAccess)world, pos.func_177984_a());
            boolean bl = gl = world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j;
            if (gl && water) {
                IBlockState newstate = state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(3));
                world.func_180501_a(pos.func_177984_a(), newstate, 2);
                world.func_190524_a(pos.func_177977_b(), (Block)Blocks.field_150355_j, pos);
            }
        }
        return false;
    }

    public boolean harvest(World world, BlockPos pos, IBlockState thisState, EntityPlayer player) {
        if (thisState != null && thisState.func_177230_c() == this && !this.isSoil(world, pos.func_177977_b())) {
            ItemStack item = new ItemStack(FoodInit.seeds, 1, 8);
            EntityItem drop = new EntityItem(world);
            drop.func_92058_a(item);
            if (player != null) {
                drop.func_70107_b(player.field_70165_t, player.field_70163_u + 0.15, player.field_70161_v);
            } else {
                drop.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)drop);
            }
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
            world.func_190524_a(pos.func_177984_a(), (Block)Blocks.field_150355_j, pos);
            return true;
        }
        return false;
    }

    public boolean canStayOnHarvest() {
        return true;
    }

    public int[] checkingRange() {
        return CoreConfigDC.ranges;
    }

    public List<DCHeatTier> getSuitableTemp(IBlockState thisState) {
        ArrayList<DCHeatTier> ret = new ArrayList<DCHeatTier>();
        ret.add(DCHeatTier.COLD);
        ret.add(DCHeatTier.COOL);
        ret.add(DCHeatTier.NORMAL);
        ret.add(DCHeatTier.WARM);
        return ret;
    }

    public List<DCHumidity> getSuitableHum(IBlockState thisState) {
        ArrayList<DCHumidity> ret = new ArrayList<DCHumidity>();
        ret.add(DCHumidity.UNDERWATER);
        return ret;
    }

    public List<DCAirflow> getSuitableAir(IBlockState thisState) {
        ArrayList<DCAirflow> ret = new ArrayList<DCAirflow>();
        ret.add(DCAirflow.TIGHT);
        return ret;
    }

    public String getCollectableTool() {
        return "shears";
    }

    public boolean isCollectable(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return false;
        }
        return item.func_77973_b() instanceof ItemShears || item.func_77973_b() instanceof ItemSword;
    }

    public int getCollectArea(ItemStack item) {
        return 3;
    }

    public boolean doCollect(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack tool) {
        return this.harvest(world, pos, state, player);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean up = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean down = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        int i = 0;
        i = up ? (down ? 2 : 1) : (down ? 3 : 0);
        return state.func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(i));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.STAGE4, BlockFluidBase.LEVEL});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return this.isSuitablePlace(world, pos, state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state);
    }

    public String[] getNameSuffix() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public String getTexture(int meta, int side, boolean face) {
        int m = meta & 3;
        String b = "dcs_climate:blocks/crop/";
        return b + "seaweed_" + m;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), world.field_72995_K ? 11 : 3);
    }
}

