/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.capability;

import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import net.minecraft.nbt.NBTTagCompound;

public class DrinkCustomizer
implements IDrinkCustomize {
    public byte milkID = 0;
    public byte sugarID = 0;
    public byte agingLevel = 0;

    @Override
    public DrinkMilk getMilk() {
        return DrinkMilk.getFromId(this.milkID);
    }

    @Override
    public DrinkSugar getSugar() {
        return DrinkSugar.getFromId(this.sugarID);
    }

    @Override
    public int getAgingLevel() {
        return this.agingLevel;
    }

    @Override
    public boolean setMilk(DrinkMilk milk) {
        this.milkID = (byte)milk.id;
        return true;
    }

    @Override
    public boolean setSugar(DrinkSugar sugar) {
        this.sugarID = (byte)sugar.id;
        return true;
    }

    @Override
    public boolean setAging(int l) {
        if (l > 100) {
            l = 100;
        }
        this.agingLevel = (byte)l;
        return true;
    }

    public DrinkCustomizer readFromNBT(NBTTagCompound nbt) {
        byte sugar;
        byte milk;
        this.milkID = nbt.func_74764_b(DrinkMilk.getTagKey()) ? (milk = nbt.func_74771_c(DrinkMilk.getTagKey())) : (byte)0;
        this.sugarID = nbt.func_74764_b(DrinkSugar.getTagKey()) ? (sugar = nbt.func_74771_c(DrinkSugar.getTagKey())) : (byte)0;
        this.agingLevel = nbt.func_74764_b("dcs.drink.aging") ? (sugar = nbt.func_74771_c("dcs.drink.aging")) : (byte)0;
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.milkID == 0) {
            nbt.func_74774_a(DrinkMilk.getTagKey(), this.milkID);
        } else {
            nbt.func_82580_o(DrinkMilk.getTagKey());
        }
        if (this.sugarID == 0) {
            nbt.func_74774_a(DrinkSugar.getTagKey(), this.sugarID);
        } else {
            nbt.func_82580_o(DrinkSugar.getTagKey());
        }
        if (this.agingLevel == 0) {
            nbt.func_74774_a("dcs.drink.aging", this.agingLevel);
        } else {
            nbt.func_82580_o("dcs.drink.aging");
        }
        return nbt;
    }
}

