/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.capability;

import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DrinkItemCustomizer
implements IDrinkCustomize {
    public final ItemStack cont;
    public static final String AGING_KEY = "dcs.drink.aging";

    public DrinkItemCustomizer(ItemStack item) {
        this.cont = item;
    }

    @Override
    public DrinkMilk getMilk() {
        if (DCUtil.isEmpty((ItemStack)this.cont)) {
            return DrinkMilk.NONE;
        }
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag != null && tag.func_74764_b(DrinkMilk.getTagKey())) {
            byte id = tag.func_74771_c(DrinkMilk.getTagKey());
            DrinkMilk ret = DrinkMilk.getFromId(id);
            return ret;
        }
        return DrinkMilk.NONE;
    }

    @Override
    public DrinkSugar getSugar() {
        if (DCUtil.isEmpty((ItemStack)this.cont)) {
            return DrinkSugar.NONE;
        }
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag != null && tag.func_74764_b(DrinkSugar.getTagKey())) {
            byte id = tag.func_74771_c(DrinkSugar.getTagKey());
            DrinkSugar ret = DrinkSugar.getFromId(id);
            return ret;
        }
        return DrinkSugar.NONE;
    }

    @Override
    public int getAgingLevel() {
        if (DCUtil.isEmpty((ItemStack)this.cont)) {
            return 0;
        }
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag != null && tag.func_74764_b(AGING_KEY)) {
            byte i = tag.func_74771_c(AGING_KEY);
            return i;
        }
        return 0;
    }

    @Override
    public boolean setMilk(DrinkMilk milk) {
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a(DrinkMilk.getTagKey(), (byte)milk.id);
        this.cont.func_77982_d(tag);
        return true;
    }

    @Override
    public boolean setSugar(DrinkSugar sugar) {
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a(DrinkSugar.getTagKey(), (byte)sugar.id);
        this.cont.func_77982_d(tag);
        return true;
    }

    @Override
    public boolean setAging(int level) {
        NBTTagCompound tag = this.cont.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (level > 100) {
            level = 100;
        }
        tag.func_74774_a(AGING_KEY, (byte)level);
        this.cont.func_77982_d(tag);
        return true;
    }
}

