/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.capability;

import defeatedcrow.hac.core.util.DCUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public enum DrinkMilk {
    NONE(0, 1.0f),
    MILK(1, 2.0f),
    CREAM(2, 4.0f),
    SOY(3, 3.0f),
    CITRUS(4, 3.0f);

    public final float effect;
    public final int id;

    private DrinkMilk(int i, float param) {
        this.effect = param;
        this.id = i;
    }

    public static DrinkMilk getFromId(int i) {
        if (i == 0) {
            return NONE;
        }
        if (i == 1) {
            return MILK;
        }
        if (i == 2) {
            return CREAM;
        }
        if (i == 3) {
            return SOY;
        }
        if (i == 4) {
            return CITRUS;
        }
        return NONE;
    }

    public static String getTagKey() {
        return "dcs.drink.milk";
    }

    public static DrinkMilk isMilkItem(ItemStack item) {
        IFluidHandler cont;
        FluidStack f;
        if (DCUtil.isEmpty((ItemStack)item)) {
            return NONE;
        }
        if (item.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (f = (cont = (IFluidHandler)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents()) != null && f.getFluid() != null) {
            String name = FluidRegistry.getFluidName((Fluid)f.getFluid());
            if (name.contains("soy") || name.contains("Soy")) {
                return SOY;
            }
            if (name.contains("cream") || name.contains("Cream")) {
                return CREAM;
            }
            if (name.contains("milk") || name.contains("Milk")) {
                return MILK;
            }
            if (name.contains("lemon") || name.contains("lime")) {
                return CITRUS;
            }
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)item);
        DrinkMilk ret = NONE;
        for (int i : ids) {
            String name = OreDictionary.getOreName((int)i);
            if (name.contains("soy") || name.contains("Soy")) {
                ret = SOY;
                continue;
            }
            if (name.contains("cream") || name.contains("Cream")) {
                ret = CREAM;
                continue;
            }
            if (name.contains("milk") || name.contains("Milk")) {
                if (ret == SOY) continue;
                ret = MILK;
                continue;
            }
            if (!name.contains("cropLemon") && !name.contains("cropLime")) continue;
            ret = CITRUS;
        }
        return ret;
    }
}

