/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.entity;

import defeatedcrow.hac.core.base.DCEntityBase;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class EntityTeaCupSilver
extends DCEntityBase {
    protected static final DataParameter<String> FLUID = EntityDataManager.func_187226_a(EntityTeaCupSilver.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Integer> AMOUNT = EntityDataManager.func_187226_a(EntityTeaCupSilver.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> MILK = EntityDataManager.func_187226_a(EntityTeaCupSilver.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> SUGAR = EntityDataManager.func_187226_a(EntityTeaCupSilver.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> AGING = EntityDataManager.func_187226_a(EntityTeaCupSilver.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityTeaCupSilver(World worldIn) {
        super(worldIn);
    }

    public EntityTeaCupSilver(World worldIn, double posX, double posY, double posZ) {
        super(worldIn, posX, posY, posZ);
    }

    public EntityTeaCupSilver(World worldIn, double posX, double posY, double posZ, @Nullable EntityPlayer player) {
        super(worldIn, posX, posY, posZ, player);
    }

    public EntityTeaCupSilver setFluid(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            this.field_70180_af.func_187227_b(FLUID, (Object)"empty");
            this.field_70180_af.func_187227_b(AMOUNT, (Object)0);
        } else {
            this.field_70180_af.func_187227_b(FLUID, (Object)FluidRegistry.getFluidName((FluidStack)fluid));
            this.field_70180_af.func_187227_b(AMOUNT, (Object)fluid.amount);
        }
        return this;
    }

    public EntityTeaCupSilver setCustom(DrinkMilk milk, DrinkSugar sugar, int aging) {
        this.field_70180_af.func_187227_b(MILK, (Object)((byte)milk.id));
        this.field_70180_af.func_187227_b(SUGAR, (Object)((byte)sugar.id));
        this.field_70180_af.func_187227_b(AGING, (Object)((byte)aging));
        return this;
    }

    protected ItemStack drops() {
        ItemStack drop = new ItemStack(FoodInit.cupSilver, 1, 0);
        IFluidHandlerItem cont = (IFluidHandlerItem)drop.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        IDrinkCustomize drink = (IDrinkCustomize)drop.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
        Fluid f = FluidRegistry.getFluid((String)this.getFluidName());
        int amo = this.getAmount();
        if (cont != null && f != null && amo > 0) {
            cont.fill(new FluidStack(f, amo), true);
        }
        if (drink != null) {
            drink.setMilk(DrinkMilk.getFromId(this.getMilk()));
            drink.setSugar(DrinkSugar.getFromId(this.getSugar()));
            drink.setAging(this.getAging());
        }
        return drop;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLUID, (Object)"empty");
        this.field_70180_af.func_187214_a(AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(MILK, (Object)0);
        this.field_70180_af.func_187214_a(SUGAR, (Object)0);
        this.field_70180_af.func_187214_a(AGING, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        String s = tag.func_74779_i("dcs.entityfluid");
        int a = tag.func_74762_e("dcs.entityamo");
        byte m = tag.func_74771_c("dcs.entitymilk");
        byte su = tag.func_74771_c("dcs.entitysugar");
        byte ag = tag.func_74771_c("dcs.entityaging");
        this.field_70180_af.func_187227_b(FLUID, (Object)s);
        this.field_70180_af.func_187227_b(AMOUNT, (Object)a);
        this.field_70180_af.func_187227_b(MILK, (Object)m);
        this.field_70180_af.func_187227_b(SUGAR, (Object)su);
        this.field_70180_af.func_187227_b(AGING, (Object)ag);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        String s = this.getFluidName();
        int a = this.getAmount();
        byte m = this.getMilk();
        byte su = this.getSugar();
        byte ag = this.getAging();
        tag.func_74768_a("dcs.entityamo", a);
        tag.func_74778_a("dcs.entityfluid", s);
        tag.func_74774_a("dcs.entitymilk", m);
        tag.func_74774_a("dcs.entitysugar", su);
        tag.func_74774_a("dcs.entityaging", ag);
    }

    public String getFluidName() {
        return (String)this.field_70180_af.func_187225_a(FLUID);
    }

    public int getAmount() {
        return (Integer)this.field_70180_af.func_187225_a(AMOUNT);
    }

    public byte getMilk() {
        return (Byte)this.field_70180_af.func_187225_a(MILK);
    }

    public byte getSugar() {
        return (Byte)this.field_70180_af.func_187225_a(SUGAR);
    }

    public byte getAging() {
        return (Byte)this.field_70180_af.func_187225_a(AGING);
    }
}

