/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.gui;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.food.block.TileIncubator;
import defeatedcrow.hac.food.gui.ContainerIncubator;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiIncubator
extends GuiContainer {
    private static final ResourceLocation guiTex = new ResourceLocation("dcs_climate", "textures/gui/incubator_gui.png");
    private static final ResourceLocation iconTex = new ResourceLocation("dcs_climate", "textures/gui/gui_icons.png");
    private final InventoryPlayer playerInventory;
    private final TileIncubator tile;

    public GuiIncubator(TileIncubator te, InventoryPlayer playerInv) {
        super((Container)new ContainerIncubator(te, playerInv));
        this.playerInventory = playerInv;
        this.tile = te;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)this.tile.func_70005_c_(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 3, 0x404040);
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        super.func_73863_a(x, y, par3);
        ArrayList<String> list = new ArrayList<String>();
        if (this.tile != null && this.tile.getClimate() != null) {
            DCHeatTier h;
            IClimate clm = this.tile.getClimate();
            if (this.func_146978_c(5, 25, 50, 40, x, y)) {
                list.add(I18n.func_135052_a((String)"dcs.tip.incubator_gui", (Object[])new Object[0]));
            }
            if (this.func_146978_c(12, 28, 40, 6, x, y) && clm != null) {
                h = clm.getHeat();
                list.add(h.toString());
            }
            if (this.func_146978_c(12, 42, 40, 6, x, y) && clm != null) {
                h = clm.getHumidity();
                list.add(h.toString());
            }
            if (this.func_146978_c(12, 56, 40, 6, x, y) && clm != null) {
                h = clm.getAirflow();
                list.add(h.toString());
            }
        }
        if (!list.isEmpty()) {
            this.func_146283_a(list, x, y);
        }
        this.func_191948_b(x, y);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiIncubator.guiTex());
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile != null && this.tile.getClimate() != null) {
            IClimate clm = this.tile.getClimate();
            this.field_146297_k.func_110434_K().func_110577_a(iconTex);
            if (clm != null) {
                int cl = clm.getHeat().getID() * 3;
                this.func_73729_b(i + 10 + cl, j + 25, 1, 25, 5, 10);
                int ch = clm.getHumidity().getID() * 11;
                this.func_73729_b(i + 13 + ch, j + 39, 1, 25, 5, 10);
                int ca = clm.getAirflow().getID() * 11;
                this.func_73729_b(i + 13 + ca, j + 53, 1, 25, 5, 10);
            }
        }
    }

    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        boolean flag = this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100);
        if ((mouseButton == 0 || mouseButton == 1 || flag) && this.func_146978_c(10, 20, 40, 60, x, y)) {
            IClimate ret;
            int c;
            DCHeatTier heat = this.tile.getClimate().getHeat();
            DCHumidity hum = this.tile.getClimate().getHumidity();
            DCAirflow air = this.tile.getClimate().getAirflow();
            if (this.func_146978_c(10, 28, 40, 6, x, y)) {
                c = (x - 10 - this.field_147003_i) / 3;
                if (c > 13) {
                    c = 13;
                }
                heat = DCHeatTier.getTypeByID((int)c);
            }
            if (this.func_146978_c(10, 42, 40, 6, x, y)) {
                c = (x - 10 - this.field_147003_i) / 10;
                if (c > 3) {
                    c = 3;
                }
                hum = DCHumidity.getTypeByID((int)c);
            }
            if (this.func_146978_c(10, 56, 40, 6, x, y)) {
                c = (x - 10 - this.field_147003_i) / 10;
                if (c > 3) {
                    c = 3;
                }
                air = DCAirflow.getTypeByID((int)c);
            }
            if ((ret = ClimateAPI.register.getClimateFromParam(heat, hum, air)) != this.tile.getClimate()) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.tile.setClimateAndPacket(ret);
            }
        }
    }

    protected static ResourceLocation guiTex() {
        return guiTex;
    }
}

