/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.DrinkGingerEntity;
import defeatedcrow.hac.food.entity.DrinkKuzuEntity;
import defeatedcrow.hac.food.entity.DrinkTomatoEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DrinkItem
extends FoodItemBase {
    public DrinkItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 2;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)2);
        String s = "items/food/drink_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"ginger", "kuzu", "tomato"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new DrinkGingerEntity(world, x, y, z, player);
        if (i == 1) {
            ret = new DrinkKuzuEntity(world, x, y, z, player);
        }
        if (i == 2) {
            ret = new DrinkTomatoEntity(world, x, y, z, player);
        }
        return ret;
    }

    public List<PotionEffect> getPotionEffect(int meta) {
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        ret.add(new PotionEffect(MobEffects.field_76432_h, 1, 0));
        return ret;
    }

    public int getFoodAmo(int meta) {
        return 2;
    }

    public float getSaturation(int meta) {
        return 0.2f;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
        String effName = I18n.func_135052_a((String)MobEffects.field_76432_h.func_76393_a(), (Object[])new Object[0]);
        tooltip.add(TextFormatting.AQUA.toString() + effName);
    }
}

