/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.food.item.ItemFluidPack;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidPaperContDC
implements IFluidHandlerItem,
ICapabilityProvider {
    protected final ItemStack container;

    public FluidPaperContDC(ItemStack container) {
        this.container = container;
    }

    @Nullable
    public FluidStack getFluid() {
        int meta = this.container.func_77952_i();
        String name = ItemFluidPack.getFluidName(meta);
        Fluid fluid = FluidRegistry.getFluid((String)name);
        if (fluid != null) {
            return new FluidStack(fluid, 250);
        }
        return null;
    }

    protected void setFluid(FluidStack resource) {
        if (this.container.func_190916_E() != 1 || resource == null || !this.canFillFluidType(resource)) {
            return;
        }
        int meta = ItemFluidPack.getMetaFromFluid(resource.getFluid());
        if (meta == 0) {
            return;
        }
        this.container.func_77964_b(meta);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 250)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 250 || !this.canFillFluidType(resource)) {
            return 0;
        }
        int fillAmo = 250;
        int meta = ItemFluidPack.getMetaFromFluid(resource.getFluid());
        if (meta == 0) {
            return 0;
        }
        if (doFill) {
            this.container.func_77964_b(meta);
        }
        return fillAmo;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 250 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain < 250) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = 250;
        FluidStack drained = contained.copy();
        drained.amount = 250;
        if (doDrain) {
            this.setContainerToEmpty();
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.container.func_77952_i() <= 0;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container.func_77964_b(0);
        if (this.container.func_77978_p() != null) {
            this.container.func_77982_d(null);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

