/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.IceCreamBerryEntity;
import defeatedcrow.hac.food.entity.IceCreamCocoaEntity;
import defeatedcrow.hac.food.entity.IceCreamCookieEntity;
import defeatedcrow.hac.food.entity.IceCreamEntity;
import defeatedcrow.hac.food.entity.IceCreamKinakoEntity;
import defeatedcrow.hac.food.entity.IceCreamLemonEntity;
import defeatedcrow.hac.food.entity.ParfaitBerryEntity;
import defeatedcrow.hac.food.entity.ParfaitCitrusEntity;
import defeatedcrow.hac.food.entity.ParfaitWatermelonEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IceCreamItem
extends FoodItemBase {
    public IceCreamItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 8;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)8);
        String s = "items/food/icecream";
        s = s + "_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"milk", "kinako", "berry", "lemon", "cookie", "cocoa", "parfait_berry", "parfait_citrus", "parfait_watermelon"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new IceCreamEntity(world, x, y, z, player);
        if (i == 1) {
            ret = new IceCreamKinakoEntity(world, x, y, z, player);
        }
        if (i == 2) {
            ret = new IceCreamBerryEntity(world, x, y, z, player);
        }
        if (i == 3) {
            ret = new IceCreamLemonEntity(world, x, y, z, player);
        }
        if (i == 4) {
            ret = new IceCreamCookieEntity(world, x, y, z, player);
        }
        if (i == 5) {
            ret = new IceCreamCocoaEntity(world, x, y, z, player);
        }
        if (i == 6) {
            ret = new ParfaitBerryEntity(world, x, y, z, player);
        }
        if (i == 7) {
            ret = new ParfaitCitrusEntity(world, x, y, z, player);
        }
        if (i == 8) {
            ret = new ParfaitWatermelonEntity(world, x, y, z, player);
        }
        return ret;
    }

    public List<PotionEffect> getPotionEffect(int meta) {
        List ret = super.getPotionEffect(meta);
        int i = meta == 6 || meta == 7 || meta == 8 ? 3600 : 600;
        ret.add(new PotionEffect(MobEffects.field_76426_n, i, 0));
        return ret;
    }

    public int getFoodAmo(int meta) {
        if (meta == 6 || meta == 7 || meta == 8) {
            return 12;
        }
        return meta == 0 ? 3 : 4;
    }

    public float getSaturation(int meta) {
        return 0.15f;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
        int i = stack.func_77952_i() == 6 || stack.func_77952_i() == 7 || stack.func_77952_i() == 8 ? 3600 : 600;
        PotionEffect eff = new PotionEffect(MobEffects.field_76426_n, i);
        String effName = I18n.func_135052_a((String)MobEffects.field_76426_n.func_76393_a(), (Object[])new Object[0]);
        effName = effName + " (" + StringUtils.func_76337_a((int)i) + ")";
        tooltip.add(TextFormatting.AQUA.toString() + effName);
    }
}

