/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ClimateDoubleCropBase;
import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemDCSeeds
extends DCItem
implements IPlantable {
    private final int maxMeta;
    private static String[] names = new String[]{"rice", "onion", "spinach", "tomato", "coffee", "cotton", "lotus", "herb", "seaweed", "soy", "bean", "chili", "garlic", "lettuce", "wisteria", "ginger", "grape"};

    public ItemDCSeeds(int max) {
        this.maxMeta = max;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/seed_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || DCUtil.isEmpty((ItemStack)player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        int meta = stack.func_77952_i();
        IBlockState state = world.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            Block crop = this.getCropBlock(meta);
            if (crop == FoodInit.cropLotusN) {
                if (((IClimateCrop)crop).isSuitablePlace(world, pos, state) && world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                    world.func_180501_a(pos, crop.func_176223_P(), 3);
                    DCUtil.reduceStackSize((ItemStack)stack, (int)1);
                    return EnumActionResult.SUCCESS;
                }
            } else if (crop instanceof IClimateCrop && ((IClimateCrop)crop).isSuitablePlace(world, pos, state) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                world.func_180501_a(pos.func_177984_a(), crop.func_176223_P(), 3);
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    private Block getCropBlock(int meta) {
        switch (meta) {
            case 0: {
                return FoodInit.cropRice;
            }
            case 1: {
                return FoodInit.cropOnion;
            }
            case 2: {
                return FoodInit.cropSpinach;
            }
            case 3: {
                return FoodInit.cropTomato;
            }
            case 4: {
                return FoodInit.cropCoffee;
            }
            case 5: {
                return FoodInit.cropCotton;
            }
            case 6: {
                return FoodInit.cropLotusN;
            }
            case 7: {
                return FoodInit.cropHerb;
            }
            case 8: {
                return FoodInit.cropSeaweed;
            }
            case 9: {
                return FoodInit.cropSoy;
            }
            case 10: {
                return FoodInit.cropBean;
            }
            case 11: {
                return FoodInit.cropChili;
            }
            case 12: {
                return FoodInit.cropGarlic;
            }
            case 13: {
                return FoodInit.cropLettuce;
            }
            case 14: {
                return FoodInit.cropWisteria;
            }
            case 15: {
                return FoodInit.cropGinger;
            }
            case 16: {
                return FoodInit.cropGrape;
            }
        }
        return FoodInit.cropRice;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ClimateCropBase || state.func_177230_c() instanceof ClimateDoubleCropBase) {
            return EnumPlantType.Crop;
        }
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof IClimateCrop)) {
            return FoodInit.cropRice.func_176223_P();
        }
        return state;
    }
}

