/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.DrinkItemCustomizer;
import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import defeatedcrow.hac.food.entity.EntityTeaCupSilver;
import defeatedcrow.hac.food.entity.EntityTeaCupWhite;
import defeatedcrow.hac.food.entity.EntityTumbler;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.plugin.DCIntegrationCore;
import defeatedcrow.hac.plugin.DrinkPotionType;
import defeatedcrow.hac.plugin.sd.DCThirstHelperSD;
import defeatedcrow.hac.plugin.tan.DCThirstHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSilverCup
extends FoodItemBase {
    public ItemSilverCup(boolean isWolfFood) {
        super(isWolfFood);
        this.func_77625_d(1);
        this.func_77848_i();
    }

    public int getMaxMeta() {
        return 2;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)1);
        String s = "items/food/cup_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"silver", "white", "glass"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FluidStack f = null;
        DrinkMilk milk = DrinkMilk.NONE;
        DrinkSugar sugar = DrinkSugar.NONE;
        int aging = 0;
        IFluidHandlerItem cont = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        IDrinkCustomize drink = (IDrinkCustomize)item.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
        if (cont != null && cont.getTankProperties() != null && cont.getTankProperties().length > 0) {
            f = cont.getTankProperties()[0].getContents();
        }
        if (drink != null) {
            milk = drink.getMilk();
            sugar = drink.getSugar();
            aging = drink.getAgingLevel();
        }
        EntityTeaCupSilver ret = null;
        switch (i) {
            case 1: {
                ret = new EntityTeaCupWhite(world, x, y, z, player).setFluid(f).setCustom(milk, sugar, aging);
                break;
            }
            case 2: {
                ret = new EntityTumbler(world, x, y, z, player).setFluid(f).setCustom(milk, sugar, aging);
                break;
            }
            default: {
                ret = new EntityTeaCupSilver(world, x, y, z, player).setFluid(f).setCustom(milk, sugar, aging);
            }
        }
        return ret;
    }

    public int getFoodAmo(int meta) {
        return 1;
    }

    public float getSaturation(int meta) {
        return 0.25f;
    }

    public ItemStack getFoodContainerItem(ItemStack item) {
        ItemStack ret = new ItemStack((Item)this, 1, item.func_77952_i());
        return ret;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            FluidStack f;
            IFluidHandlerItem cont;
            ItemStack item = player.func_184586_b(hand);
            if (!DCUtil.isEmpty((ItemStack)item) && (cont = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && cont.getTankProperties() != null && cont.getTankProperties().length > 0 && (f = cont.getTankProperties()[0].getContents()) != null) {
                return super.func_77659_a(world, player, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)item);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
    }

    public boolean addEffects(ItemStack stack, World world, EntityLivingBase living) {
        if (!world.field_72995_K && !DCUtil.isEmpty((ItemStack)stack)) {
            if (stack.func_77973_b() != this) {
                return false;
            }
            IFluidHandlerItem cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            IDrinkCustomize drink = (IDrinkCustomize)stack.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
            if (cont != null && cont.getTankProperties() != null && cont.getTankProperties().length > 0) {
                FluidStack f = cont.getTankProperties()[0].getContents();
                float durF = 1.0f;
                int ampF = 0;
                if (drink != null) {
                    durF *= drink.getMilk().effect;
                    ampF += drink.getSugar().effect;
                    int l = drink.getAgingLevel();
                    if (l > 0) {
                        ampF += l;
                        durF *= (float)l;
                    }
                }
                if (f != null && f.getFluid() != null) {
                    if (living instanceof EntityPlayer && DCIntegrationCore.loadedTaN) {
                        DCThirstHelper.onDrink((EntityPlayer)living, f.getFluid());
                    }
                    if (living instanceof EntityPlayer && DCIntegrationCore.loadedSD) {
                        DCThirstHelperSD.drink((EntityPlayer)living, f.getFluid());
                    }
                    if (FluidDictionaryDC.matchFluidName((Fluid)f.getFluid(), (String)"milk") || f.getFluid() == MainInit.tomatoJuice || f.getFluid() == MainInit.soyMilk) {
                        living.func_70674_bp();
                        return false;
                    }
                    if (f.getFluid() == MainInit.mazai) {
                        living.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 2, 0));
                        living.func_70691_i(30.0f);
                        if (world.field_73012_v.nextInt(100) == 0) {
                            living.func_70097_a(DamageSource.field_76377_j, 20.0f);
                        }
                        return false;
                    }
                    List<PotionEffect> effects = ItemSilverCup.getPotionEffect(f.getFluid(), durF, ampF);
                    if (!effects.isEmpty()) {
                        for (PotionEffect get : effects) {
                            Potion por;
                            if (get == null || get.func_188419_a() == null || (por = get.func_188419_a()) == null) continue;
                            int amp = get.func_76458_c();
                            int dur = get.func_76459_b();
                            if (living.func_70644_a(get.func_188419_a())) {
                                PotionEffect check = living.func_70660_b(por);
                                dur += check.func_76459_b();
                            }
                            living.func_70690_d(new PotionEffect(get.func_188419_a(), dur, amp));
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static List<PotionEffect> getPotionEffect(Fluid fluid, float durF, int ampF) {
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        if (fluid != null) {
            if (DrinkPotionType.isRegistered(fluid)) {
                DrinkPotionType.PotionSet potion = DrinkPotionType.getPotionSet(fluid);
                if (potion != null) {
                    float duration;
                    float f = duration = potion.potion.func_76398_f() ? 600.0f * durF : 1200.0f * durF;
                    if (potion.potion == MobEffects.field_76432_h || potion.potion == MobEffects.field_76433_i) {
                        duration = 1.0f * durF;
                    }
                    ret.add(new PotionEffect(potion.potion, MathHelper.func_76123_f((float)duration), potion.amp + ampF));
                }
            } else {
                ret.add(new PotionEffect(MobEffects.field_76428_l, MathHelper.func_76123_f((float)(300.0f * durF)), ampF));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        IFluidHandlerItem cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        IDrinkCustomize drink = (IDrinkCustomize)stack.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
        if (cont != null && cont.getTankProperties() != null && drink != null && cont.getTankProperties().length > 0) {
            FluidStack f = cont.getTankProperties()[0].getContents();
            float durF = 1.0f * drink.getMilk().effect;
            int ampF = drink.getSugar().effect;
            int l = drink.getAgingLevel();
            if (l > 0) {
                ampF += l;
                durF *= (float)l;
            }
            if (f != null && f.getFluid() != null) {
                if (FluidDictionaryDC.matchFluidName((Fluid)f.getFluid(), (String)"milk") || f.getFluid() == MainInit.tomatoJuice || f.getFluid() == MainInit.soyMilk) {
                    tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"dcs.tip.clear_potion", (Object[])new Object[0]));
                } else if (f.getFluid() == MainInit.mazai) {
                    tooltip.add(TextFormatting.RED.toString() + I18n.func_135052_a((String)"dcs.tip.danger_drink", (Object[])new Object[0]));
                } else {
                    PotionEffect eff;
                    List<PotionEffect> effects = ItemSilverCup.getPotionEffect(f.getFluid(), durF, ampF);
                    if (!effects.isEmpty() && (eff = effects.get(0)) != null && eff.func_188419_a() != null) {
                        String effName = I18n.func_135052_a((String)eff.func_76453_d(), (Object[])new Object[0]);
                        effName = effName + " " + I18n.func_135052_a((String)("potion.potency." + eff.func_76458_c()), (Object[])new Object[0]).trim();
                        effName = effName + " (" + Potion.func_188410_a((PotionEffect)eff, (float)1.0f) + ")";
                        tooltip.add(TextFormatting.AQUA.toString() + effName);
                    }
                }
                if (ClimateCore.proxy.isShiftKeyDown()) {
                    tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
                    tooltip.add(DCName.DRINK_CUSTOMIZE.getLocalizedName());
                    tooltip.add(TextFormatting.BOLD.toString() + "= CONTAINED FLUID =");
                    tooltip.add("Fluid: " + f.getLocalizedName());
                    tooltip.add("Amount: " + f.amount);
                    tooltip.add(TextFormatting.BOLD.toString() + "= DRINK CUSTOMIZE =");
                    tooltip.add("Milk: " + drink.getMilk().toString());
                    tooltip.add("Sugar: " + drink.getSugar().toString());
                    if (l > 0) {
                        tooltip.add("Aging Level: " + l);
                    }
                } else {
                    String mes = "";
                    mes = mes + f.getLocalizedName();
                    mes = drink.getMilk() == DrinkMilk.NONE ? (drink.getSugar() == DrinkSugar.NONE ? mes + " BLACK" : mes + " " + drink.getSugar().toString()) : (drink.getSugar() == DrinkSugar.NONE ? mes + " " + drink.getMilk().toString() : mes + " " + drink.getMilk().toString() + "," + drink.getSugar().toString());
                    if (l > 0) {
                        mes = mes + " (Aged)";
                    }
                    tooltip.add(TextFormatting.BOLD.toString() + mes);
                    tooltip.add(TextFormatting.RESET.toString() + I18n.func_135052_a((String)"dcs.tip.shift", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(TextFormatting.BOLD.toString() + "EMPTY");
            }
        } else {
            tooltip.add(TextFormatting.BOLD.toString() + "EMPTY");
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapWrapper(stack);
    }

    private class CapWrapper
    implements ICapabilityProvider {
        private final ItemStack cont;

        private CapWrapper(ItemStack item) {
            this.cont = item;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return true;
            }
            return capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)new FluidHandlerItemStack(this.cont, 200);
            }
            if (capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY) {
                return (T)new DrinkItemCustomizer(this.cont);
            }
            return null;
        }
    }
}

