/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.PizzaRoeEntity;
import defeatedcrow.hac.food.entity.PizzaTeriyakiEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PizzaItem
extends FoodItemBase {
    public PizzaItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 3;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)3);
        String s = "items/food/pizza_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"roe_raw", "roe_baked", "teriyaki_raw", "teriyaki_baked"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new PizzaRoeEntity(world, x, y, z, player);
        if (i == 2 || i == 3) {
            ret = new PizzaTeriyakiEntity(world, x, y, z, player);
        }
        if ((i & 1) == 0) {
            ret.setRAW(true);
        }
        return ret;
    }

    public int getFoodAmo(int meta) {
        switch (meta) {
            case 1: 
            case 3: {
                return 14;
            }
        }
        return 0;
    }

    public float getSaturation(int meta) {
        return (meta & 1) == 0 ? 0.0f : 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
    }
}

