/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.entity.PlateBeefEntity;
import defeatedcrow.hac.food.entity.PlateBigChickenEntity;
import defeatedcrow.hac.food.entity.PlateBigGarlicEntity;
import defeatedcrow.hac.food.entity.PlateChickenEntity;
import defeatedcrow.hac.food.entity.PlateFishEntity;
import defeatedcrow.hac.food.entity.PlatePorkEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlateMeatItem
extends FoodItemBase {
    public PlateMeatItem(boolean isWolfFood) {
        super(isWolfFood);
        this.func_77642_a(FoodInit.steakplate);
    }

    public int getMaxMeta() {
        return 11;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)1);
        String s = "items/food/plate_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"beef_raw", "beef_baked", "pork_raw", "pork_baked", "chicken_raw", "chicken_baked", "fish_raw", "fish_baked", "big_garlic_raw", "big_garlic_baked", "big_chicken_raw", "big_chicken_baked"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new PlateBeefEntity(world, x, y, z, player);
        if (i == 2 || i == 3) {
            ret = new PlatePorkEntity(world, x, y, z, player);
        }
        if (i == 4 || i == 5) {
            ret = new PlateChickenEntity(world, x, y, z, player);
        }
        if (i == 6 || i == 7) {
            ret = new PlateFishEntity(world, x, y, z, player);
        }
        if (i == 8 || i == 9) {
            ret = new PlateBigGarlicEntity(world, x, y, z, player);
            ret.setIndividual(world.field_73012_v.nextInt(32));
        }
        if (i == 10 || i == 11) {
            ret = new PlateBigChickenEntity(world, x, y, z, player);
        }
        if ((i & 1) == 0) {
            ret.setRAW(true);
        }
        return ret;
    }

    public int getFoodAmo(int meta) {
        switch (meta) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return 0;
            }
            case 1: {
                return 10;
            }
            case 3: {
                return 10;
            }
            case 5: {
                return 10;
            }
            case 7: {
                return 12;
            }
            case 9: 
            case 11: {
                return 16;
            }
        }
        return 0;
    }

    public float getSaturation(int meta) {
        return meta == 9 || meta == 11 ? 1.0f : ((meta & 1) == 0 ? 0.0f : 0.6f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
    }
}

