/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.entity.PlateGratinEntity;
import defeatedcrow.hac.food.entity.PlateGyozaEntity;
import defeatedcrow.hac.food.entity.PlateMeatPaellaEntity;
import defeatedcrow.hac.food.entity.PlatePaellaEntity;
import defeatedcrow.hac.food.entity.PlatePotatoEntity;
import defeatedcrow.hac.food.entity.PlateSoupEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlateSoupItem
extends FoodItemBase {
    public PlateSoupItem(boolean isWolfFood) {
        super(isWolfFood);
        this.func_77642_a(FoodInit.steakplate);
    }

    public int getMaxMeta() {
        return 11;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)11);
        String s = "items/food/plate_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"potato_raw", "potato_baked", "tomato_raw", "tomato_baked", "gratin_raw", "gratin_baked", "paella_raw", "paella_baked", "meat_paella_raw", "meat_paella_baked", "gyoza_raw", "gyoza_baked"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new PlatePotatoEntity(world, x, y, z, player);
        if (i == 2 || i == 3) {
            ret = new PlateSoupEntity(world, x, y, z, player);
        }
        if (i == 4 || i == 5) {
            ret = new PlateGratinEntity(world, x, y, z, player);
        }
        if (i == 6 || i == 7) {
            ret = new PlatePaellaEntity(world, x, y, z, player);
        }
        if (i == 8 || i == 9) {
            ret = new PlateMeatPaellaEntity(world, x, y, z, player);
        }
        if (i == 10 || i == 11) {
            ret = new PlateGyozaEntity(world, x, y, z, player);
        }
        if ((i & 1) == 0) {
            ret.setRAW(true);
        }
        ret.setIndividual(world.field_73012_v.nextInt(32));
        DCLogger.debugLog((String)("individual " + ret.getIndividual()));
        return ret;
    }

    public int getFoodAmo(int meta) {
        switch (meta) {
            case 0: 
            case 2: {
                return 0;
            }
            case 1: 
            case 3: {
                return 12;
            }
            case 5: {
                return 10;
            }
            case 7: 
            case 9: 
            case 11: {
                return 16;
            }
        }
        return 0;
    }

    public float getSaturation(int meta) {
        return (meta & 1) == 0 ? 0.0f : 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
    }
}

