/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.EntityRiceBall;
import defeatedcrow.hac.food.entity.EntityRiceBallMiso;
import defeatedcrow.hac.food.entity.EntityRiceBallRoe;
import defeatedcrow.hac.food.entity.EntityRiceBallSeaweed;
import defeatedcrow.hac.food.entity.EntityRiceBowl;
import defeatedcrow.hac.food.entity.EntityRiceMushroom;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RiceBowlItem
extends FoodItemBase {
    public RiceBowlItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 5;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)5);
        String s = "items/food/rice_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/rice_" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"boiled", "mushroom", "ball", "ball_seaweed", "ball_miso", "ball_roe"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new EntityRiceBowl(world, x, y, z, player);
        switch (i) {
            case 1: {
                ret = new EntityRiceMushroom(world, x, y, z, player);
                break;
            }
            case 2: {
                ret = new EntityRiceBall(world, x, y, z, player);
                break;
            }
            case 3: {
                ret = new EntityRiceBallSeaweed(world, x, y, z, player);
                break;
            }
            case 4: {
                ret = new EntityRiceBallMiso(world, x, y, z, player);
                break;
            }
            case 5: {
                ret = new EntityRiceBallRoe(world, x, y, z, player);
            }
        }
        return ret;
    }

    public int getFoodAmo(int meta) {
        return meta == 0 ? 5 : 6;
    }

    public float getSaturation(int meta) {
        return 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
    }
}

