/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.StickBeefEntity;
import defeatedcrow.hac.food.entity.StickFishEntity;
import defeatedcrow.hac.food.entity.StickGoheiEntity;
import defeatedcrow.hac.food.entity.StickMarshmallowEntity;
import defeatedcrow.hac.food.entity.StickMotuEntity;
import defeatedcrow.hac.food.entity.StickMuttonEntity;
import defeatedcrow.hac.food.entity.StickPorkEntity;
import defeatedcrow.hac.food.entity.StickSquidEntity;
import defeatedcrow.hac.food.entity.StickYakitoriEntity;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StickFoodsItem
extends FoodItemBase {
    public StickFoodsItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 17;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)0, (int)meta, (int)17);
        String s = "items/food/stick_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"fish_raw", "fish_cooked", "yakitori_raw", "yakitori_cooked", "pork_raw", "pork_cooked", "beef_raw", "beef_cooked", "mutton_raw", "mutton_cooked", "squid_raw", "squid_cooked", "gohei_raw", "gohei_cooked", "marshmallow_raw", "marshmallow_cooked", "motu_raw", "motu_cooked"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = null;
        switch (i) {
            case 0: 
            case 1: {
                ret = new StickFishEntity(world, x, y, z, player);
                break;
            }
            case 2: 
            case 3: {
                ret = new StickYakitoriEntity(world, x, y, z, player);
                break;
            }
            case 4: 
            case 5: {
                ret = new StickPorkEntity(world, x, y, z, player);
                break;
            }
            case 6: 
            case 7: {
                ret = new StickBeefEntity(world, x, y, z, player);
                break;
            }
            case 8: 
            case 9: {
                ret = new StickMuttonEntity(world, x, y, z, player);
                break;
            }
            case 10: 
            case 11: {
                ret = new StickSquidEntity(world, x, y, z, player);
                break;
            }
            case 12: 
            case 13: {
                ret = new StickGoheiEntity(world, x, y, z, player);
                break;
            }
            case 14: 
            case 15: {
                ret = new StickMarshmallowEntity(world, x, y, z, player);
                break;
            }
            case 16: 
            case 17: {
                ret = new StickMotuEntity(world, x, y, z, player);
                break;
            }
            default: {
                ret = new StickFishEntity(world, x, y, z, player);
            }
        }
        if (ret != null && (i & 1) == 0) {
            ret.setRAW(true);
        }
        ret.setIndividual(world.field_73012_v.nextInt(32));
        return ret;
    }

    public int getFoodAmo(int meta) {
        switch (meta) {
            case 1: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 4;
            }
            case 17: {
                return 7;
            }
        }
        return 1;
    }

    public float getSaturation(int meta) {
        return (meta & 1) == 0 ? 0.0f : 0.6f;
    }

    public ItemStack getFoodContainerItem(ItemStack item) {
        ItemStack ret = new ItemStack(Items.field_151055_y);
        return ret;
    }

    public List<PotionEffect> getPotionEffect(int meta) {
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        if ((meta & 1) == 0 && meta != 14) {
            ret.add(new PotionEffect(MobEffects.field_76438_s, 300, 0));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
    }
}

