/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item;

import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.base.FoodItemBase;
import defeatedcrow.hac.food.entity.YogurtPlainEntity;
import defeatedcrow.hac.food.entity.YogurtSPEntity;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class YogurtItem
extends FoodItemBase {
    public YogurtItem(boolean isWolfFood) {
        super(isWolfFood);
    }

    public int getMaxMeta() {
        return 1;
    }

    public String getTexPath(int meta, boolean f) {
        int i = MathHelper.func_76125_a((int)meta, (int)0, (int)1);
        String s = "items/food/yogurt_" + this.getNameSuffix()[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public String[] getNameSuffix() {
        String[] s = new String[]{"plain", "special"};
        return s;
    }

    public Entity getPlacementEntity(World world, EntityPlayer player, double x, double y, double z, ItemStack item) {
        int i = item.func_77960_j();
        FoodEntityBase ret = new YogurtPlainEntity(world, x, y, z, player);
        if (i == 1) {
            ret = new YogurtSPEntity(world, x, y, z, player);
        }
        return ret;
    }

    public int getFoodAmo(int meta) {
        return 6;
    }

    public float getSaturation(int meta) {
        return 0.2f;
    }

    public List<PotionEffect> getPotionEffect(int meta) {
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        if (meta == 1) {
            ret.add(new PotionEffect(MainInit.immunity, 3600, 0));
        } else {
            ret.add(new PotionEffect(MainInit.digestive, 1200, 0));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        tooltip.add(DCName.PLACEABLE_ENTITY.getLocalizedName());
        if (stack.func_77952_i() == 0) {
            String effName2 = I18n.func_135052_a((String)MainInit.digestive.func_76393_a(), (Object[])new Object[0]);
            tooltip.add(TextFormatting.AQUA.toString() + effName2);
        } else {
            String effName = I18n.func_135052_a((String)MainInit.immunity.func_76393_a(), (Object[])new Object[0]);
            tooltip.add(TextFormatting.AQUA.toString() + effName);
        }
    }
}

