/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.item.brewing.ItemLiquorBottle;
import defeatedcrow.hac.food.item.brewing.ItemRoseWaterBottle;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBottleContDC
implements IFluidHandlerItem,
ICapabilityProvider {
    protected ItemStack container;

    public FluidBottleContDC(ItemStack container) {
        this.container = container;
    }

    @Nullable
    public FluidStack getFluid() {
        Fluid fluid = FluidBottleContDC.getFluid(this.container);
        if (fluid != null) {
            return new FluidStack(fluid, 500);
        }
        return null;
    }

    protected void setFluid(FluidStack resource) {
        if (this.container.func_190916_E() != 1 || resource == null || !this.canFillFluidType(resource)) {
            return;
        }
        this.container = FluidBottleContDC.getItemFromFluid(resource.getFluid());
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 500)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 500 || !this.canFillFluidType(resource)) {
            return 0;
        }
        int fillAmo = 500;
        ItemStack ret = FluidBottleContDC.getItemFromFluid(resource.getFluid());
        if (DCUtil.isEmpty((ItemStack)ret)) {
            return 0;
        }
        if (doFill) {
            this.container = ret;
        }
        return fillAmo;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 500 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain < 500) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = 500;
        FluidStack drained = contained.copy();
        drained.amount = 500;
        if (doDrain) {
            this.setContainerToEmpty();
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (DCUtil.isEmpty((ItemStack)this.container)) {
            return false;
        }
        return this.container.func_77952_i() == 0 && this.container.func_77973_b() == FoodInit.liquorBottle;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container = new ItemStack(FoodInit.liquorBottle);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public static Fluid getFluid(ItemStack item) {
        if (!DCUtil.isEmpty((ItemStack)item)) {
            if (item.func_77973_b() == FoodInit.liquorBottle) {
                String name = ItemLiquorBottle.getFluidName(item.func_77952_i());
                return FluidRegistry.getFluid((String)name);
            }
            if (item.func_77973_b() == FoodInit.roseWaterBottle) {
                String name = ItemRoseWaterBottle.getFluidName(item.func_77952_i());
                return FluidRegistry.getFluid((String)name);
            }
        }
        return null;
    }

    public static ItemStack getItemFromFluid(Fluid fluid) {
        if (fluid == FoodInit.roseWater) {
            ItemStack ret = new ItemStack(FoodInit.roseWaterBottle);
            return ret;
        }
        int meta = -1;
        if (fluid == FoodInit.beer) {
            meta = 1;
        } else if (fluid == FoodInit.wine) {
            meta = 2;
        } else if (fluid == FoodInit.sake) {
            meta = 3;
        } else if (fluid == FoodInit.dateWine) {
            meta = 4;
        } else if (fluid == FoodInit.whisky) {
            meta = 5;
        } else if (fluid == FoodInit.brandy) {
            meta = 6;
        } else if (fluid == FoodInit.pomaceBrandy) {
            meta = 7;
        } else if (fluid == FoodInit.shotyu) {
            meta = 8;
        } else if (fluid == FoodInit.araq) {
            meta = 9;
        } else if (fluid == FoodInit.whiteRum) {
            meta = 10;
        } else if (fluid == FoodInit.darkRum) {
            meta = 11;
        } else if (fluid == FoodInit.akvavit) {
            meta = 12;
        } else if (fluid == FoodInit.vodka) {
            meta = 13;
        } else if (fluid == FoodInit.netherWine) {
            meta = 14;
        } else if (fluid == FoodInit.chorusLiquor) {
            meta = 15;
        } else if (fluid == FoodInit.awamori) {
            meta = 16;
        }
        if (meta > 0) {
            return new ItemStack(FoodInit.liquorBottle, 1, meta);
        }
        return ItemStack.field_190927_a;
    }
}

