/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEssentialOil
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"rose", "citrus", "mint", "birch", "lotus", "lavender"};

    public ItemEssentialOil() {
        this.maxMeta = 5;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/brewing/oil_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (!world.field_72995_K && !DCUtil.isEmpty((ItemStack)stack)) {
                EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(player.field_70170_p);
                cloud.func_82149_j((Entity)player);
                cloud.func_184481_a((EntityLivingBase)player);
                cloud.func_184483_a(5.0f);
                cloud.func_184495_b(-1.0f);
                cloud.func_184485_d(10);
                cloud.func_184486_b(3600);
                cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
                cloud.func_184484_a(this.getType(stack.func_77952_i()));
                player.field_70170_p.func_72838_d((Entity)cloud);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public PotionType getType(int meta) {
        String name = "dcs.essence_" + meta;
        return new PotionType(name, new PotionEffect[]{this.getEffect(meta)});
    }

    public PotionEffect getEffect(int meta) {
        switch (meta) {
            case 0: {
                return new PotionEffect(MainInit.wideMining, 14400);
            }
            case 1: {
                return new PotionEffect(MainInit.immunity, 14400);
            }
            case 2: {
                return new PotionEffect(MainInit.ocean, 14400);
            }
            case 3: {
                return new PotionEffect(MainInit.reflexion, 14400);
            }
            case 4: {
                return new PotionEffect(MainInit.absorptionEXP, 14400);
            }
            case 5: {
                return new PotionEffect(MainInit.warp, 14400);
            }
        }
        return new PotionEffect(MainInit.wideMining, 14400);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            int m = stack.func_77952_i();
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.essencial_oil", (Object[])new Object[0]));
            PotionEffect eff = this.getEffect(m);
            if (eff != null && eff.func_188419_a() != null) {
                String effName = I18n.func_135052_a((String)eff.func_76453_d(), (Object[])new Object[0]);
                effName = effName + " " + I18n.func_135052_a((String)("potion.potency." + eff.func_76458_c()), (Object[])new Object[0]).trim();
                effName = effName + " (" + Potion.func_188410_a((PotionEffect)eff, (float)0.25f) + ")";
                tooltip.add(TextFormatting.AQUA.toString() + effName);
            }
        }
    }
}

