/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.DrinkItemCustomizer;
import defeatedcrow.hac.food.capability.DrinkMilk;
import defeatedcrow.hac.food.capability.DrinkSugar;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import defeatedcrow.hac.food.item.ItemSilverCup;
import defeatedcrow.hac.food.item.brewing.FluidBottleContDC;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.plugin.DCIntegrationCore;
import defeatedcrow.hac.plugin.sd.DCThirstHelperSD;
import defeatedcrow.hac.plugin.tan.DCThirstHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLiquorBottle
extends DCItem {
    private static String[] names = new String[]{"empty", "beer", "wine", "sake", "date_wine", "whisky", "brandy", "pomace_brandy", "shotyu", "araq", "rum_white", "rum", "akvavit", "vodka", "nether", "ender", "awamori"};
    public static final String[] FLUIDS = new String[]{"empty", "dcs.beer", "dcs.wine", "dcs.sake", "dcs.date", "dcs.whisky", "dcs.brandy", "dcs.pomace_brandy", "dcs.shotyu", "dcs.araq", "dcs.white_rum", "dcs.dark_rum", "dcs.akvavit", "dcs.vodka", "dcs.nether", "dcs.chorus_liquor", "dcs.awamori"};

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() != 0;
    }

    public int getMaxMeta() {
        return 16;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        int i = meta;
        if (i > this.getMaxMeta()) {
            i = this.getMaxMeta();
        }
        String s = "items/food/brewing/bottle_" + names[i];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public int getItemBurnTime(ItemStack stack) {
        int i = stack.func_77960_j();
        if (i > 4 && i < 13) {
            return 800;
        }
        if (i == 13) {
            return 1600;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        Fluid f;
        if (stack == null) {
            return;
        }
        String s = "";
        int i = stack.func_77952_i();
        if (i > this.getMaxMeta()) {
            i = this.getMaxMeta();
        }
        if ((f = FluidRegistry.getFluid((String)FLUIDS[i])) != null) {
            PotionEffect eff;
            tooltip.add(TextFormatting.BOLD.toString() + DCName.DRINK_CUSTOMIZE.getLocalizedName());
            IDrinkCustomize drink = (IDrinkCustomize)stack.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
            float durF = 3.0f;
            int ampF = 0;
            int l = 0;
            if (drink != null) {
                durF *= drink.getMilk().effect;
                ampF += drink.getSugar().effect;
                l = drink.getAgingLevel();
                if (l > 0) {
                    ampF += l;
                    durF *= (float)l;
                }
            }
            String mes = "";
            mes = mes + DCName.FLUID.getLocalizedName() + ": " + f.getLocalizedName(new FluidStack(f, 500));
            if (drink != null) {
                String mes2 = "";
                if (drink.getMilk() != DrinkMilk.NONE) {
                    mes2 = mes2 + drink.getMilk().toString();
                }
                if (drink.getSugar() != DrinkSugar.NONE) {
                    if (mes2.length() > 1) {
                        mes2 = mes2 + ",";
                    }
                    mes2 = mes2 + drink.getSugar().toString();
                }
                if (l > 0) {
                    mes = mes + " (Aged)";
                }
                if (mes2.length() > 1) {
                    mes = mes + " (" + mes2 + ")";
                }
            }
            tooltip.add(TextFormatting.YELLOW.toString() + mes);
            tooltip.add(TextFormatting.YELLOW.toString() + DCName.AMOUNT.getLocalizedName() + ": " + 500);
            List<PotionEffect> effects = ItemSilverCup.getPotionEffect(f, durF, ampF);
            if (!effects.isEmpty() && (eff = effects.get(0)) != null && eff.func_188419_a() != null) {
                String effName = I18n.func_135052_a((String)eff.func_76453_d(), (Object[])new Object[0]);
                effName = effName + " " + I18n.func_135052_a((String)("potion.potency." + eff.func_76458_c()), (Object[])new Object[0]).trim();
                effName = effName + " (" + Potion.func_188410_a((PotionEffect)eff, (float)1.0f) + ")";
                tooltip.add(TextFormatting.AQUA.toString() + effName);
            }
        } else {
            tooltip.add(TextFormatting.YELLOW.toString() + "Fluid is empty: " + FLUIDS[i]);
        }
    }

    public static String getFluidName(int meta) {
        if (meta > 16) {
            meta = 16;
        }
        return FLUIDS[meta];
    }

    public static Fluid getFluid(int meta) {
        String name = ItemLiquorBottle.getFluidName(meta);
        return FluidRegistry.getFluid((String)name);
    }

    public static int getMetaFromFluid(Fluid fluid) {
        int meta = 0;
        if (fluid == FoodInit.beer) {
            meta = 1;
        } else if (fluid == FoodInit.wine) {
            meta = 2;
        } else if (fluid == FoodInit.sake) {
            meta = 3;
        } else if (fluid == FoodInit.dateWine) {
            meta = 4;
        } else if (fluid == FoodInit.whisky) {
            meta = 5;
        } else if (fluid == FoodInit.brandy) {
            meta = 6;
        } else if (fluid == FoodInit.pomaceBrandy) {
            meta = 7;
        } else if (fluid == FoodInit.shotyu) {
            meta = 8;
        } else if (fluid == FoodInit.araq) {
            meta = 9;
        } else if (fluid == FoodInit.whiteRum) {
            meta = 10;
        } else if (fluid == FoodInit.darkRum) {
            meta = 11;
        } else if (fluid == FoodInit.akvavit) {
            meta = 12;
        } else if (fluid == FoodInit.vodka) {
            meta = 13;
        } else if (fluid == FoodInit.netherWine) {
            meta = 14;
        } else if (fluid == FoodInit.chorusLiquor) {
            meta = 15;
        } else if (fluid == FoodInit.awamori) {
            meta = 16;
        }
        return meta;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!DCUtil.isEmpty((ItemStack)stack) && stack.func_77960_j() == 0) {
            if (target instanceof EntityCow) {
                if (!player.field_70170_p.field_72995_K) {
                    EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, new ItemStack((Item)this, 1, 0));
                    player.field_70170_p.func_72838_d((Entity)drop);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DCUtil.reduceStackSize((ItemStack)stack, (int)1);
                }
                return true;
            }
        } else if (this.addEffects(stack, player.field_70170_p, target)) {
            this.dropContainerItem(player.field_70170_p, stack, (EntityLivingBase)player);
            DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            return true;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        ActionResult ret;
        ItemStack item;
        if (player != null && !DCUtil.isEmpty((ItemStack)(item = player.func_184586_b(hand))) && (ret = super.onItemRightClick2(world, player, hand)).func_188397_a() == EnumActionResult.PASS) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return super.onItemRightClick2(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase living) {
        int meta = stack.func_77960_j();
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.addEffects(stack, worldIn, living);
            if (!player.field_71075_bZ.field_75098_d) {
                this.dropContainerItem(worldIn, stack, living);
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            }
        }
        return stack;
    }

    public boolean addEffects(ItemStack stack, World world, EntityLivingBase living) {
        if (!world.field_72995_K && !DCUtil.isEmpty((ItemStack)stack) && living != null) {
            int meta = stack.func_77960_j();
            if (meta == 0) {
                return false;
            }
            Fluid fluid = ItemLiquorBottle.getFluid(meta);
            List<PotionEffect> effects = ItemSilverCup.getPotionEffect(fluid, 3.0f, 1);
            IDrinkCustomize drink = (IDrinkCustomize)stack.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
            float durF = 1.0f;
            int ampF = 0;
            if (drink != null) {
                durF *= drink.getMilk().effect;
                ampF += drink.getSugar().effect;
                int l = drink.getAgingLevel();
                if (l > 0) {
                    ++ampF;
                    durF *= (float)l;
                }
            }
            if (living instanceof EntityPlayer && DCIntegrationCore.loadedTaN) {
                DCThirstHelper.onDrink((EntityPlayer)living, fluid);
            }
            if (living instanceof EntityPlayer && DCIntegrationCore.loadedSD) {
                DCThirstHelperSD.drink((EntityPlayer)living, fluid);
            }
            if (!effects.isEmpty()) {
                for (PotionEffect get : effects) {
                    Potion por;
                    if (get == null || get.func_188419_a() == null || (por = get.func_188419_a()) == null) continue;
                    int amp = get.func_76458_c() * ampF;
                    int dur = MathHelper.func_76123_f((float)((float)get.func_76459_b() * durF));
                    if (living.func_70644_a(get.func_188419_a())) {
                        PotionEffect check = living.func_70660_b(por);
                        dur += check.func_76459_b();
                    }
                    living.func_70690_d(new PotionEffect(get.func_188419_a(), dur, amp));
                }
            }
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public void dropContainerItem(World world, ItemStack food, EntityLivingBase living) {
        ItemStack stack;
        if (!world.field_72995_K && living != null && !DCUtil.isEmpty((ItemStack)(stack = this.getContainerItem(food)))) {
            EntityItem drop = new EntityItem(world, living.field_70165_t, living.field_70163_u + 0.25, living.field_70161_v, stack);
            world.func_72838_d((Entity)drop);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapWrapper(stack);
    }

    private class CapWrapper
    implements ICapabilityProvider {
        private final ItemStack cont;

        private CapWrapper(ItemStack item) {
            this.cont = item;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return true;
            }
            return capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)new FluidBottleContDC(this.cont);
            }
            if (capability == DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY) {
                return (T)new DrinkItemCustomizer(this.cont);
            }
            return null;
        }
    }
}

