/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.item.brewing.ItemUnidentified;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.EnumHabitat;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.IMediumItem;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMedium
extends DCItem
implements IMediumItem {
    private final int maxMeta;
    private static String[] names = new String[]{"simple", "standard", "potato", "giblets", "bacteria"};

    public ItemMedium() {
        this.maxMeta = 4;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/brewing/medium_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            ItemStack item = player.func_184586_b(hand);
            if (!DCUtil.isEmpty((ItemStack)item)) {
                BlockPos pos;
                RayTraceResult res;
                EnumMedium type = this.getMedium(item);
                IMicrobe current = ItemMedium.getMicrobeData(item);
                if (current == null && (res = this.func_77621_a(world, player, true)) != null && res.field_72313_a == RayTraceResult.Type.BLOCK && (pos = res.func_178782_a()).func_177956_o() > 0 && pos.func_177956_o() < 255) {
                    IMicrobe microbe;
                    IBlockState state = world.func_180495_p(pos);
                    EnumHabitat habitat = EnumHabitat.getHabitat(world, pos);
                    if (habitat != null && (microbe = MainAPIManager.microbeRegister.collectSpecies(habitat, type)) != null) {
                        if (!world.field_72995_K) {
                            ItemStack ret = ItemMedium.setMicrobeItem(item.func_77946_l(), microbe, null);
                            ret.func_190920_e(1);
                            EntityItem drop = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, ret);
                            world.func_72838_d((Entity)drop);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            DCUtil.redAndDel((ItemStack)item, (int)1);
                        }
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                    }
                }
            }
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!DCUtil.isEmpty((ItemStack)stack) && target instanceof IAnimals) {
            IMicrobe microbe;
            EnumMedium type = this.getMedium(stack);
            IMicrobe current = ItemMedium.getMicrobeData(stack);
            if (current == null && type != null && (microbe = MainAPIManager.microbeRegister.collectSpecies(EnumHabitat.ANIMAL, type)) != null) {
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack ret = ItemMedium.setMicrobeItem(stack.func_77946_l(), microbe, null);
                    ret.func_190920_e(1);
                    EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, ret);
                    player.field_70170_p.func_72838_d((Entity)drop);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DCUtil.redAndDel((ItemStack)stack, (int)1);
                }
                player.func_184185_a(SoundEvents.field_187733_dX, 0.75f, 1.25f);
                return true;
            }
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    @Override
    public EnumMedium getMedium(ItemStack item) {
        if (DCUtil.isEmpty((ItemStack)item)) {
            return EnumMedium.SIMPLE;
        }
        int meta = item.func_77952_i();
        switch (meta) {
            case 0: {
                return EnumMedium.SIMPLE;
            }
            case 1: {
                return EnumMedium.STANDARD;
            }
            case 2: {
                return EnumMedium.POTATO;
            }
            case 3: {
                return EnumMedium.GIBLETS;
            }
            case 4: {
                return EnumMedium.BACTERIA;
            }
        }
        return EnumMedium.SIMPLE;
    }

    @Override
    public ItemStack getMediumItem(EnumMedium medium) {
        int meta = 0;
        if (medium != null) {
            switch (medium) {
                case SIMPLE: {
                    meta = 0;
                    break;
                }
                case STANDARD: {
                    meta = 1;
                    break;
                }
                case POTATO: {
                    meta = 2;
                    break;
                }
                case GIBLETS: {
                    meta = 3;
                    break;
                }
                case BACTERIA: {
                    meta = 4;
                    break;
                }
                default: {
                    meta = 0;
                }
            }
        }
        return new ItemStack((Item)this, 1, meta);
    }

    public static ItemStack getMicrobeItem(ItemStack item) {
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o()) {
            IMicrobe microbe = ItemMedium.getMicrobeData(item);
            EnumRarity rarity = ItemMedium.getMicrobeRarity(item);
            ItemStack ret = ItemStack.field_190927_a;
            if (microbe != null) {
                if (rarity == null) {
                    ret = ItemUnidentified.setSpecies(microbe);
                    return ret;
                }
                if (microbe.getMicrobeItem() != null) {
                    int i = 0;
                    if (rarity == EnumRarity.UNCOMMON) {
                        i = 1;
                    }
                    if (rarity == EnumRarity.RARE) {
                        i = 2;
                    }
                    ret = new ItemStack(microbe.getMicrobeItem(), 1, i);
                    return ret;
                }
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack setMicrobeItem(ItemStack item, IMicrobe microbe, EnumRarity rarity) {
        if (!DCUtil.isEmpty((ItemStack)item) && microbe != null) {
            if (item.func_77942_o() && item.func_77978_p().func_74764_b("microbe_name")) {
                return item;
            }
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("microbe_name", microbe.getName());
            if (rarity == null) {
                tag.func_74768_a("microbe_rarity", 0);
            }
            if (rarity == EnumRarity.COMMON) {
                tag.func_74768_a("microbe_rarity", 1);
            }
            if (rarity == EnumRarity.UNCOMMON) {
                tag.func_74768_a("microbe_rarity", 2);
            }
            if (rarity == EnumRarity.RARE) {
                tag.func_74768_a("microbe_rarity", 3);
            }
            if (rarity == EnumRarity.EPIC) {
                tag.func_74768_a("microbe_rarity", 4);
            }
            item.func_77982_d(tag);
        }
        return item;
    }

    public static IMicrobe getMicrobeData(ItemStack item) {
        String key;
        IMicrobe ret;
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("microbe_name") && (ret = MainAPIManager.microbeRegister.getSpecies(key = tag.func_74779_i("microbe_name"))) != null) {
            return ret;
        }
        return null;
    }

    public static EnumRarity getMicrobeRarity(ItemStack item) {
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("microbe_rarity")) {
            int key = tag.func_74762_e("microbe_rarity");
            switch (key) {
                case 0: {
                    return null;
                }
                case 1: {
                    return EnumRarity.COMMON;
                }
                case 2: {
                    return EnumRarity.UNCOMMON;
                }
                case 3: {
                    return EnumRarity.RARE;
                }
                case 4: {
                    return EnumRarity.EPIC;
                }
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (!DCUtil.isEmpty((ItemStack)stack) && stack.func_77942_o()) {
            IMicrobe microbe = ItemMedium.getMicrobeData(stack);
            EnumRarity rarity = ItemMedium.getMicrobeRarity(stack);
            if (microbe != null) {
                tooltip.add(TextFormatting.BOLD.toString() + "=== Cultivation Data ===");
                if (rarity == null) {
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.unidentified", (Object[])new Object[0]) + " " + microbe.getType().localize());
                } else {
                    tooltip.add(I18n.func_135052_a((String)(microbe.getMicrobeItem().func_77658_a() + ".name"), (Object[])new Object[0]).trim());
                    tooltip.add(TextFormatting.BOLD.toString() + rarity);
                }
                if (stack.func_77978_p().func_74764_b("microbe_days")) {
                    int i = stack.func_77978_p().func_74762_e("microbe_days");
                    tooltip.add(I18n.func_135052_a((String)"dcs.tip.incubation_days", (Object[])new Object[]{i}));
                }
                if (stack.func_77978_p().func_74764_b("microbe_baddays")) {
                    tooltip.add(TextFormatting.BOLD.toString() + TextFormatting.RED.toString() + I18n.func_135052_a((String)"dcs.tip.vbnc", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(TextFormatting.BOLD.toString() + "EMPTY");
            }
        } else {
            tooltip.add(TextFormatting.BOLD.toString() + "EMPTY");
        }
    }
}

