/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import com.google.common.collect.ImmutableList;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.item.brewing.MicrobeItem;
import defeatedcrow.hac.main.api.brewing.EnumHabitat;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.EnumMicrobeType;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import java.util.List;
import net.minecraft.item.Item;

public class ItemMicrobeBacillus
extends MicrobeItem
implements IMicrobe {
    @Override
    public Item getMicrobeItem() {
        return FoodInit.bacillus;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/brewing/bacilli_bacillus";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @Override
    public String getName() {
        return "bacillus";
    }

    @Override
    public boolean getGramStaining() {
        return true;
    }

    @Override
    public int getIncubationDays() {
        return 2;
    }

    @Override
    public EnumMicrobeType getType() {
        return EnumMicrobeType.BACILLI;
    }

    @Override
    public int getChance(EnumHabitat habitat) {
        switch (habitat) {
            case ANIMAL: {
                return 10;
            }
            case CROP: {
                return 40;
            }
            case FLOWER: {
                return 10;
            }
            case SOIL: {
                return 10;
            }
            case WATER: {
                return 15;
            }
        }
        return 0;
    }

    @Override
    public List<EnumMedium> getMediums() {
        return ImmutableList.of((Object)((Object)EnumMedium.SIMPLE), (Object)((Object)EnumMedium.STANDARD));
    }

    @Override
    public List<DCHeatTier> getHeats() {
        return ImmutableList.of((Object)DCHeatTier.NORMAL, (Object)DCHeatTier.WARM, (Object)DCHeatTier.HOT, (Object)DCHeatTier.BOIL);
    }

    @Override
    public List<DCHumidity> getHums() {
        return ImmutableList.of((Object)DCHumidity.NORMAL, (Object)DCHumidity.WET);
    }

    @Override
    public List<DCAirflow> getAirs() {
        return ImmutableList.of((Object)DCAirflow.NORMAL, (Object)DCAirflow.FLOW, (Object)DCAirflow.WIND);
    }

    public String[] getNameSuffix() {
        return null;
    }
}

