/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import com.google.common.collect.ImmutableList;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.item.brewing.MicrobeItem;
import defeatedcrow.hac.main.api.brewing.EnumHabitat;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.EnumMicrobeType;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import java.util.List;
import net.minecraft.item.Item;

public class ItemMicrobeYeast
extends MicrobeItem
implements IMicrobe {
    @Override
    public Item getMicrobeItem() {
        return FoodInit.beerYeast;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/brewing/yeast_beer";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @Override
    public String getName() {
        return "yeast";
    }

    @Override
    public boolean getGramStaining() {
        return true;
    }

    @Override
    public int getIncubationDays() {
        return 3;
    }

    @Override
    public EnumMicrobeType getType() {
        return EnumMicrobeType.YEAST;
    }

    @Override
    public int getChance(EnumHabitat habitat) {
        switch (habitat) {
            case ANIMAL: {
                return 0;
            }
            case CROP: {
                return 0;
            }
            case FLOWER: {
                return 40;
            }
            case SOIL: {
                return 15;
            }
            case WATER: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public List<EnumMedium> getMediums() {
        return ImmutableList.of((Object)((Object)EnumMedium.SIMPLE), (Object)((Object)EnumMedium.STANDARD), (Object)((Object)EnumMedium.POTATO));
    }

    @Override
    public List<DCHeatTier> getHeats() {
        return ImmutableList.of((Object)DCHeatTier.COOL, (Object)DCHeatTier.NORMAL, (Object)DCHeatTier.WARM);
    }

    @Override
    public List<DCHumidity> getHums() {
        return ImmutableList.of((Object)DCHumidity.NORMAL, (Object)DCHumidity.WET);
    }

    @Override
    public List<DCAirflow> getAirs() {
        return ImmutableList.of((Object)DCAirflow.NORMAL, (Object)DCAirflow.FLOW);
    }

    public String[] getNameSuffix() {
        return null;
    }
}

