/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.item.ItemSilverCup;
import defeatedcrow.hac.food.item.brewing.FluidBottleContDC;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.plugin.DCIntegrationCore;
import defeatedcrow.hac.plugin.tan.DCThirstHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRoseWaterBottle
extends DCItem {
    public static final String[] FLUIDS = new String[]{"dcs.rose_water"};

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack(FoodInit.liquorBottle);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public int getMaxMeta() {
        return 0;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexPath(int meta, boolean f) {
        int i = meta;
        if (i > this.getMaxMeta()) {
            i = this.getMaxMeta();
        }
        String s = "items/food/brewing/bottle_rose_water";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        Fluid f;
        if (stack == null) {
            return;
        }
        String s = "";
        int i = stack.func_77952_i();
        if (i > this.getMaxMeta()) {
            i = this.getMaxMeta();
        }
        if ((f = FluidRegistry.getFluid((String)"dcs.rose_water")) != null) {
            PotionEffect eff;
            float durF = 3.0f;
            int ampF = 0;
            String mes = "";
            mes = mes + DCName.FLUID.getLocalizedName() + ": " + f.getLocalizedName(new FluidStack(f, 500));
            tooltip.add(TextFormatting.YELLOW.toString() + mes);
            tooltip.add(TextFormatting.YELLOW.toString() + DCName.AMOUNT.getLocalizedName() + ": " + 500);
            List<PotionEffect> effects = ItemSilverCup.getPotionEffect(f, durF, ampF);
            if (!effects.isEmpty() && (eff = effects.get(0)) != null && eff.func_188419_a() != null) {
                String effName = I18n.func_135052_a((String)eff.func_76453_d(), (Object[])new Object[0]);
                effName = effName + " " + I18n.func_135052_a((String)("potion.potency." + eff.func_76458_c()), (Object[])new Object[0]).trim();
                effName = effName + " (" + Potion.func_188410_a((PotionEffect)eff, (float)1.0f) + ")";
                tooltip.add(TextFormatting.AQUA.toString() + effName);
            }
        } else {
            tooltip.add(TextFormatting.YELLOW.toString() + "Fluid is empty: dcs.rose_water");
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!DCUtil.isEmpty((ItemStack)stack) && stack.func_77960_j() == 0) {
            if (target instanceof EntityCow) {
                if (!player.field_70170_p.field_72995_K) {
                    EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, new ItemStack(FoodInit.liquorBottle, 1, 0));
                    player.field_70170_p.func_72838_d((Entity)drop);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DCUtil.reduceStackSize((ItemStack)stack, (int)1);
                }
                return true;
            }
        } else if (this.addEffects(stack, player.field_70170_p, target)) {
            this.dropContainerItem(player.field_70170_p, stack, (EntityLivingBase)player);
            DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            return true;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        ActionResult ret;
        ItemStack item;
        if (player != null && !DCUtil.isEmpty((ItemStack)(item = player.func_184586_b(hand))) && (ret = super.onItemRightClick2(world, player, hand)).func_188397_a() == EnumActionResult.PASS) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return super.onItemRightClick2(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase living) {
        int meta = stack.func_77960_j();
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.addEffects(stack, worldIn, living);
            if (!player.field_71075_bZ.field_75098_d) {
                this.dropContainerItem(worldIn, stack, living);
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            }
        }
        return stack;
    }

    public boolean addEffects(ItemStack stack, World world, EntityLivingBase living) {
        if (!world.field_72995_K && !DCUtil.isEmpty((ItemStack)stack) && living != null) {
            int meta = stack.func_77960_j();
            if (meta == 0) {
                return false;
            }
            Fluid fluid = FluidRegistry.getFluid((String)"dcs.rose_water");
            List<PotionEffect> effects = ItemSilverCup.getPotionEffect(fluid, 3.0f, 1);
            float durF = 1.0f;
            int ampF = 0;
            if (living instanceof EntityPlayer && DCIntegrationCore.loadedTaN) {
                DCThirstHelper.onDrink((EntityPlayer)living, fluid);
            }
            if (!effects.isEmpty()) {
                for (PotionEffect get : effects) {
                    Potion por;
                    if (get == null || get.func_188419_a() == null || (por = get.func_188419_a()) == null) continue;
                    int amp = get.func_76458_c() * ampF;
                    int dur = MathHelper.func_76123_f((float)((float)get.func_76459_b() * durF));
                    if (living.func_70644_a(get.func_188419_a())) {
                        PotionEffect check = living.func_70660_b(por);
                        dur += check.func_76459_b();
                    }
                    living.func_70690_d(new PotionEffect(get.func_188419_a(), dur, amp));
                }
            }
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public void dropContainerItem(World world, ItemStack food, EntityLivingBase living) {
        ItemStack stack;
        if (!world.field_72995_K && living != null && !DCUtil.isEmpty((ItemStack)(stack = this.getContainerItem(food)))) {
            EntityItem drop = new EntityItem(world, living.field_70165_t, living.field_70163_u + 0.25, living.field_70161_v, stack);
            world.func_72838_d((Entity)drop);
        }
    }

    public static String getFluidName(int meta) {
        if (meta > 0) {
            meta = 0;
        }
        return FLUIDS[meta];
    }

    public static Fluid getFluid(int meta) {
        String name = ItemRoseWaterBottle.getFluidName(meta);
        return FluidRegistry.getFluid((String)name);
    }

    public static int getMetaFromFluid(Fluid fluid) {
        return 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapWrapper(stack);
    }

    private class CapWrapper
    implements ICapabilityProvider {
        private final ItemStack cont;

        private CapWrapper(ItemStack item) {
            this.cont = item;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)new FluidBottleContDC(this.cont);
            }
            return null;
        }
    }
}

