/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.EnumMicrobeType;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemUnidentified
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"archaea", "bacilli", "cocci", "yeast", "mold"};

    public ItemUnidentified() {
        this.maxMeta = 4;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/food/brewing/unidentified_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            IMicrobe microbe;
            ItemStack item = player.func_184586_b(hand);
            if (!DCUtil.isEmpty((ItemStack)item) && (microbe = ItemUnidentified.getSpecies(item)) != null && microbe.getMicrobeItem() != null) {
                int r = world.field_73012_v.nextInt(100);
                int meta = 0;
                if (r < 5) {
                    meta = 2;
                }
                if (r > 69) {
                    meta = 1;
                }
                ItemStack ret = new ItemStack(microbe.getMicrobeItem(), 1, meta);
                if (!world.field_72995_K) {
                    EntityItem drop = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, ret);
                    world.func_72838_d((Entity)drop);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DCUtil.redAndDel((ItemStack)item, (int)1);
                }
                player.func_184185_a(SoundEvents.field_187604_bf, 0.75f, 1.25f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
    }

    public static ItemStack setSpecies(IMicrobe sp) {
        ItemStack ret = new ItemStack(FoodInit.unidentified, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        if (sp != null) {
            if (sp.getType() == EnumMicrobeType.BACILLI) {
                ret = new ItemStack(FoodInit.unidentified, 1, 1);
            } else if (sp.getType() == EnumMicrobeType.COCCI) {
                ret = new ItemStack(FoodInit.unidentified, 1, 2);
            }
            if (sp.getType() == EnumMicrobeType.YEAST) {
                ret = new ItemStack(FoodInit.unidentified, 1, 3);
            } else if (sp.getType() == EnumMicrobeType.FUNGI) {
                ret = new ItemStack(FoodInit.unidentified, 1, 4);
            }
            tag.func_74778_a("species", sp.getName());
        } else {
            tag.func_74778_a("species", "bacillus");
        }
        ret.func_77982_d(tag);
        return ret;
    }

    public static IMicrobe getSpecies(ItemStack item) {
        String name;
        IMicrobe sp;
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("species") && (sp = MainAPIManager.microbeRegister.getSpecies(name = tag.func_74779_i("species"))) != null) {
            return sp;
        }
        return null;
    }
}

