/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.item.brewing;

import com.google.common.collect.Lists;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.api.brewing.EnumHabitat;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import defeatedcrow.hac.main.api.brewing.IMicrobeRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MicrobeRegister
implements IMicrobeRegister {
    private static List<IMicrobe> list;

    public IMicrobeRegister instance() {
        return MainAPIManager.microbeRegister;
    }

    public MicrobeRegister() {
        list = new ArrayList<IMicrobe>();
    }

    @Override
    public List<IMicrobe> getList() {
        return list;
    }

    @Override
    public boolean registerSpecies(IMicrobe species) {
        if (species != null) {
            for (IMicrobe check : this.getList()) {
                if (!check.getName().equalsIgnoreCase(species.getName())) continue;
                return false;
            }
            list.add(species);
            DCLogger.debugInfoLog((String)("Register microbe : " + species.getName()));
            return true;
        }
        return false;
    }

    @Override
    public IMicrobe getSpecies(String name) {
        if (name != null) {
            for (IMicrobe check : this.getList()) {
                if (!check.getName().equalsIgnoreCase(name)) continue;
                return check;
            }
        }
        return null;
    }

    @Override
    public IMicrobe collectSpecies(EnumHabitat habitat, EnumMedium medium) {
        int total = 1;
        Random rand = new Random();
        ArrayList set = Lists.newArrayList();
        for (IMicrobe check : this.getList()) {
            if (check.getChance(habitat) <= 0 || !check.getMediums().contains((Object)medium)) continue;
            total += check.getChance(habitat);
            set.add(check);
        }
        if (!set.isEmpty()) {
            if (set.size() < 2) {
                DCLogger.debugInfoLog((String)("get " + ((IMicrobe)set.get(0)).getName() + "/" + total));
                return (IMicrobe)set.get(0);
            }
            rand.nextInt(total);
            int r = rand.nextInt(total);
            int count = 1;
            for (IMicrobe check2 : set) {
                if ((count += check2.getChance(habitat)) < r) continue;
                DCLogger.debugInfoLog((String)("get " + check2.getName() + " " + r + "/" + total));
                return check2;
            }
            return (IMicrobe)set.get(0);
        }
        return null;
    }
}

