/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.machine.block.TileAcceptorFluidPanel;
import defeatedcrow.hac.machine.block.TileAdapterFluidPanel;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAdapterFluidPanel
extends BlockTorqueBase {
    private static BlockPos lastPos = null;
    private final boolean isAcceptor;
    protected static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_AXIS_X1 = new AxisAlignedBB(0.0, 0.125, 0.125, 0.5, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Y1 = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Z1 = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.5);
    protected static final AxisAlignedBB AABB_AXIS_X2 = new AxisAlignedBB(0.5, 0.125, 0.125, 1.0, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Y2 = new AxisAlignedBB(0.125, 0.5, 0.125, 0.875, 1.0, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Z2 = new AxisAlignedBB(0.125, 0.125, 0.5, 0.875, 0.875, 1.0);

    public BlockAdapterFluidPanel(String s, boolean acceptor) {
        super(Material.field_151571_B, s, 0);
        this.func_149672_a(SoundType.field_185852_e);
        this.isAcceptor = acceptor;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.isAcceptor) {
            return new TileAcceptorFluidPanel();
        }
        return new TileAdapterFluidPanel();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && MainUtil.isHeldWrench((EntityLivingBase)player, hand)) {
            TileEntity tile = world.func_175625_s(pos);
            if (!world.field_72995_K && tile != null) {
                if (tile instanceof TileAcceptorFluidPanel) {
                    lastPos = pos;
                    String mes1 = "Stored this coordinate: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                } else if (lastPos != null && tile instanceof TileAdapterFluidPanel) {
                    ((TileAdapterFluidPanel)tile).setPairPos(new BlockPos(lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p()));
                    String mes2 = "Registered the coordinate: " + lastPos.func_177958_n() + ", " + lastPos.func_177956_o() + ", " + lastPos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes2));
                    lastPos = null;
                }
            }
        }
        return super.onRightClick(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (DCState.hasProperty((IBlockState)state, (IProperty)DCState.SIDE)) {
            switch (DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE)) {
                case DOWN: {
                    return AABB_AXIS_Y1;
                }
                case UP: {
                    return AABB_AXIS_Y2;
                }
                case WEST: {
                    return AABB_AXIS_X1;
                }
                case EAST: {
                    return AABB_AXIS_X2;
                }
                case NORTH: {
                    return AABB_AXIS_Z1;
                }
                case SOUTH: {
                    return AABB_AXIS_Z2;
                }
            }
            return AABB_FULL;
        }
        return AABB_FULL;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K && state != null && state.func_177230_c() != null) {
            boolean cool;
            DCHeatTier heat = this.onUpdateClimate(world, pos, state);
            boolean prev = BlockAdapterFluidPanel.isLit((IBlockAccess)world, pos);
            boolean bl = cool = heat.getTier() < 0;
            if (prev != cool) {
                BlockAdapterFluidPanel.changeLitState(world, pos, cool);
            }
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public DCHeatTier onUpdateClimate(World world, BlockPos pos, IBlockState state) {
        DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(world, pos, 2, false);
        return heat;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockAdapterFluidPanel) {
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_175685_c(pos, state.func_177230_c(), true);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(false)), 3);
                world.func_175685_c(pos, state.func_177230_c(), true);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockAdapterFluidPanel)) {
            return false;
        }
        int meta = state.func_177230_c().func_176201_c(state) & 8;
        return meta > 0;
    }
}

