/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.machine.block.TileCatapult;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCatapult
extends BlockTorqueBase {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockCatapult(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHorizontal();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCatapult();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player != null && MainUtil.isHeldWrench((EntityLivingBase)player, hand) && (tile = world.func_175625_s(pos)) != null && tile instanceof TileCatapult) {
            TileCatapult cat = (TileCatapult)tile;
            int r = cat.rad;
            r = player.func_70093_af() ? (r -= 10) : (r += 10);
            if (r > 90) {
                r = 0;
            }
            if (r < 0) {
                r = 0;
            }
            cat.rad = r;
            return true;
        }
        return super.onRightClick(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile;
        if (entity != null && (tile = world.func_175625_s(pos)) != null && tile instanceof TileCatapult) {
            TileCatapult cat = (TileCatapult)tile;
            float pow = cat.pow;
            double rad = (double)cat.rad * Math.PI / 180.0;
            EnumSide side = (EnumSide)state.func_177229_b((IProperty)DCState.SIDE);
            float mX = pow * (float)Math.cos(rad) * (float)side.getFacing().func_82601_c();
            float mZ = pow * (float)Math.cos(rad) * (float)side.getFacing().func_82599_e();
            float mY = pow * (float)Math.sin(rad) * 0.5f;
            entity.func_70034_d(side.getFacing().func_185119_l());
            entity.field_70159_w = mX;
            entity.field_70181_x = mY;
            entity.field_70179_y = mZ;
            DCLogger.debugLog((String)("catapult " + pow));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.catapult", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.catapult2", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

