/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.block.TileConveyor;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConveyor
extends BlockTorqueBase {
    protected static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.125, 0.25, 0.0, 0.875, 0.375, 1.0);
    protected static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.0, 0.25, 0.125, 1.0, 0.375, 0.875);

    public BlockConveyor(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHorizontal();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileConveyor();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE).face;
        switch (face) {
            case EAST: {
                return AABB_EW;
            }
            case NORTH: {
                return AABB_NS;
            }
            case SOUTH: {
                return AABB_NS;
            }
            case WEST: {
                return AABB_EW;
            }
        }
        return AABB_NS;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity != null && !(entity instanceof EntityItem) && entity.field_70163_u > (double)pos.func_177956_o() + 0.2) {
            double mZ;
            EnumFacing face = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE).face;
            double mX = entity.field_70159_w + (double)face.func_82601_c() * 0.1;
            if (mX > 0.035) {
                mX = 0.035;
            }
            if (mX < -0.035) {
                mX = -0.035;
            }
            if ((mZ = entity.field_70179_y + (double)face.func_82599_e() * 0.1) > 0.035) {
                mZ = 0.035;
            }
            if (mZ < -0.035) {
                mZ = -0.035;
            }
            double dX = 0.0;
            if (face.func_176746_e().func_82601_c() != 0 && entity.field_70165_t < (double)pos.func_177958_n() + 0.4) {
                dX = 0.035;
            }
            if (face.func_176746_e().func_82601_c() != 0 && entity.field_70165_t > (double)pos.func_177958_n() + 0.6) {
                dX = -0.035;
            }
            double dZ = 0.0;
            if (face.func_176746_e().func_82599_e() != 0 && entity.field_70161_v < (double)pos.func_177952_p() + 0.4) {
                dZ = 0.035;
            }
            if (face.func_176746_e().func_82599_e() != 0 && entity.field_70161_v > (double)pos.func_177952_p() + 0.6) {
                dZ = -0.035;
            }
            entity.field_70159_w = mX + dX;
            entity.field_70179_y = mZ + dZ;
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileConveyor) {
            ItemStack drop2;
            TileConveyor conv = (TileConveyor)tile;
            ItemStack drop1 = conv.func_70301_a(0);
            if (!DCUtil.isEmpty((ItemStack)drop1)) {
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop1);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.25f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
            if (!DCUtil.isEmpty((ItemStack)(drop2 = conv.func_70301_a(1)))) {
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop2);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.25f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.NON_POWERED.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.ITEM.getLocalizedName() + DCName.TRANSPORT.getLocalizedName() + ": 1 item/16t");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.conveyor3", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.conveyor", (Object[])new Object[0]));
            tooltip.add(TextFormatting.RED.toString() + "SMELTING+" + TextFormatting.GRAY.toString() + " and " + TextFormatting.DARK_BLUE.toString() + "TIGHT" + TextFormatting.GRAY.toString() + ": " + I18n.func_135052_a((String)"dcs.tip.conveyor2", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }
}

