/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.block.TileDieselEngine;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDieselEngine
extends BlockTorqueBase {
    public BlockDieselEngine(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDieselEngine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player == null) return true;
        TileEntity tile = world.func_175625_s(pos);
        ItemStack held = player.func_184586_b(hand);
        if (!DCUtil.isEmpty((ItemStack)held)) {
            boolean flag = false;
            if (held.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side)) {
                FluidStack f;
                IFluidHandler cont = (IFluidHandler)held.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side);
                if (cont == null || cont.drain(1000, false) == null || !MainAPIManager.fuelRegister.isRegistered((f = cont.drain(1000, false)).getFluid())) return true;
                if (world.field_72995_K || !DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)held, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) return true;
                world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.8f, 2.0f);
                return true;
            }
            if (MainUtil.isHeldWrench((EntityLivingBase)player, hand)) {
                return super.onRightClick(world, pos, state, player, hand, side, hitX, hitY, hitZ);
            }
            if (world.field_72995_K) return true;
            player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (world.field_72995_K) return true;
        player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        boolean flag;
        if (!world.field_72995_K && ((flag = world.func_175640_z(pos)) || block.func_176223_P().func_185897_m()) && flag != (Boolean)state.func_177229_b((IProperty)DCState.POWERED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            float f = (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 0.6f : 0.5f;
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        }
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null && !placer.field_70170_p.field_72995_K && placer instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)placer;
        }
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            if (placer.field_70125_A < -75.0f) {
                face = EnumFacing.UP;
            } else if (placer.field_70125_A > 75.0f) {
                face = EnumFacing.DOWN;
            }
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)face.func_176734_d()));
        } else {
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing.func_176734_d()));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITagGetter && (tag = stack.func_77978_p()) != null) {
            ((ITagGetter)tile).setNBT(tag);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        int i = this.func_180651_a(state);
        ItemStack drop = new ItemStack((Block)this, 1, i);
        if (tile != null && tile instanceof ITagGetter) {
            NBTTagCompound tag = new NBTTagCompound();
            if ((tag = ((ITagGetter)tile).getNBT(tag)) != null) {
                drop.func_77982_d(tag);
            }
        }
        if (!world.field_72995_K) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.25f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state != null && !DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED)) {
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && rand.nextInt(c) == 0) {
                for (int i = 0; i < 5; ++i) {
                    EnumFacing face = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE).getFacing();
                    double x = (double)pos.func_177958_n() + 0.5 - (double)face.func_82601_c() * 0.4 + (double)face.func_82599_e() * 0.4;
                    double y = (double)pos.func_177956_o() + 1.0;
                    double z = (double)pos.func_177952_p() + 0.5 - (double)face.func_82599_e() * 0.4 + (double)face.func_82601_c() * 0.4;
                    double dx = 0.0;
                    double dy = 0.05;
                    double dz = 0.0;
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, dy, 0.0, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.FUEL.getLocalizedName() + ": " + DCName.FUEL_FLUID.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.TORQUE.getLocalizedName() + ": 128.0F torque/s");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(DCName.DRAIN_SIDED_TANK.getLocalizedName());
            tooltip.add(DCName.TURN_OFF.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return MainUtil.calcTankRedstone(worldIn.func_175625_s(pos));
    }
}

