/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.IAirflowTile;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.machine.block.TileFan;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFan
extends BlockTorqueBase
implements IAirflowTile {
    public BlockFan(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFan();
    }

    public DCAirflow getAirflow(World world, BlockPos pos, BlockPos target) {
        TileEntity tile = world.func_175625_s(target);
        if (tile != null && tile instanceof TileFan) {
            boolean active;
            TileFan fan = (TileFan)tile;
            EnumFacing face = fan.getBaseSide();
            boolean bl = active = this.isActive(face, pos, target) && world.func_175623_d(target.func_177972_a(face.func_176734_d()));
            if (active) {
                float torque = fan.getCurrentTorque();
                if (torque >= 5.5f) {
                    return DCAirflow.WIND;
                }
                if (torque > 0.0f) {
                    return DCAirflow.FLOW;
                }
            }
        }
        return DCAirflow.TIGHT;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            if (placer.field_70125_A < -75.0f) {
                face = EnumFacing.UP;
            } else if (placer.field_70125_A > 75.0f) {
                face = EnumFacing.DOWN;
            }
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)face.func_176734_d()));
        } else {
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing.func_176734_d()));
        }
        return state;
    }

    boolean isActive(EnumFacing face, BlockPos to, BlockPos from) {
        if (to.equals((Object)from)) {
            return true;
        }
        switch (face) {
            case DOWN: {
                return to.func_177956_o() < from.func_177956_o();
            }
            case UP: {
                return to.func_177956_o() > from.func_177956_o();
            }
            case NORTH: {
                return to.func_177952_p() < from.func_177952_p();
            }
            case SOUTH: {
                return to.func_177952_p() > from.func_177952_p();
            }
            case WEST: {
                return to.func_177958_n() < from.func_177958_n();
            }
            case EAST: {
                return to.func_177958_n() > from.func_177958_n();
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.TORQUE.getLocalizedName() + ": 6.0+ /s");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.AIR.getLocalizedName() + ": " + TextFormatting.AQUA.toString() + "WIND");
            tooltip.add(DCName.RANGE.getLocalizedName() + ": 3 x 3 x 3 blocks");
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

