/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.BlockContainerDC;
import defeatedcrow.hac.machine.block.TileFaucet;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFaucet
extends BlockContainerDC {
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.3125, 0.0, 0.5, 0.6875, 0.75, 1.0);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.75, 0.5);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.5, 0.0, 0.3125, 1.0, 0.75, 0.6875);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.5, 0.75, 0.6875);
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockFaucet(String s) {
        super(Material.field_151576_e, s);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.DOWN).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(false)));
        this.field_149787_q = false;
        this.field_149786_r = 0;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            boolean power = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            IBlockState state2 = state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(!power));
            world.func_180501_a(pos, state2, 2);
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.8f, 2.0f);
        }
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE).face;
        switch (face) {
            case EAST: {
                return AABB_EAST;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        return AABB_DOWN;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing == EnumFacing.UP) {
            facing = EnumFacing.DOWN;
        }
        state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing.func_176734_d()));
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        int m = meta & 7;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromIndex((int)m)).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int f = 0;
        int i = 0;
        f = ((EnumSide)state.func_177229_b((IProperty)DCState.SIDE)).index;
        i = (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 8 : 0;
        return i + f;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.SIDE, DCState.POWERED});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFaucet();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.NON_POWERED.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.FLUID.getLocalizedName() + " " + DCName.TRANSPORT.getLocalizedName() + ": 200 mB/t");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(DCName.RIGHT_CLICK.getLocalizedName() + ": " + DCName.TURN_OFF.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

