/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.block.TileGasBurner;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGasBurner
extends DCTileBlock
implements IHeatTile {
    public BlockGasBurner(Material m, String s, int max) {
        super(Material.field_151576_e, s, 3);
        this.func_149711_c(1.5f);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            TileEntity tile = world.func_175625_s(pos);
            if (!player.func_70093_af() && tile instanceof TileGasBurner && hand == EnumHand.MAIN_HAND) {
                FluidStack f;
                IFluidHandlerItem cont;
                boolean flag = false;
                if (!DCUtil.isEmpty((ItemStack)heldItem) && heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side) && (cont = (IFluidHandlerItem)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side)) != null && cont.drain(1000, false) != null && MainAPIManager.fuelRegister.isRegistered((f = cont.drain(1000, false)).getFluid()) && DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)heldItem, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) {
                    world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.8f, 2.0f);
                    flag = true;
                }
                if (!flag) {
                    player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGasBurner();
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public DCHeatTier getHeatTier(World world, BlockPos from, BlockPos to) {
        IBlockState state = world.func_180495_p(to);
        int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (m >= 0 && (m & 3) == 1 && (to.equals((Object)from.func_177977_b()) || to.equals((Object)from.func_177979_c(2)))) {
            return DCHeatTier.UHT;
        }
        return DCHeatTier.NORMAL;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state) & 3;
        return meta == 1 ? 15 : 0;
    }

    public static void changeLitState(World world, BlockPos pos, boolean f) {
        IBlockState state = world.func_180495_p(pos);
        int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (m >= 0) {
            int power = m & 2;
            if (f) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1 + power)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public static void changePowerState(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (m >= 0) {
            boolean power;
            int lit = m & 1;
            boolean bl = power = (m & 2) == 0;
            if (power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit + 2)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit)), 3);
            }
        }
    }

    public static boolean isLit(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return meta == 1 || meta == 3;
    }

    public static boolean isPower(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return meta == 0 || meta == 1;
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        boolean flag;
        if (!world.field_72995_K && ((flag = world.func_175640_z(pos)) || block.func_176223_P().func_185897_m())) {
            boolean power;
            int m = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
            int lit = m & 1;
            boolean flag2 = m == 1;
            boolean bl = power = (m & 2) != 0;
            if (flag && !power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit + 2)), 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
            } else if (!flag && power) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(lit)), 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.FUEL_GAS.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "UHT");
            tooltip.add(DCName.RANGE.getLocalizedName() + ": " + I18n.func_135052_a((String)"dcs.tip.upper_only", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(DCName.DRAIN_SIDED_TANK.getLocalizedName());
            tooltip.add(DCName.RS.getLocalizedName() + ": " + DCName.TURN_OFF.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return MainUtil.calcTankRedstone(worldIn.func_175625_s(pos));
    }
}

